<?php

/**
 * DO NOT EDIT!
 * This file was automatically generated via bin/generate-validator-spec.php.
 */

namespace AmpProject\Validator\Spec\Section;

use AmpProject\Exception\InvalidExtension;
use AmpProject\Exception\InvalidFormat;
use AmpProject\Exception\InvalidSpecName;
use AmpProject\Exception\InvalidTagId;
use AmpProject\Extension;
use AmpProject\Format;
use AmpProject\Internal;
use AmpProject\Tag as Element;
use AmpProject\Validator\Spec\IterableSection;
use AmpProject\Validator\Spec\Iteration;
use AmpProject\Validator\Spec\Tag;
use AmpProject\Validator\Spec\TagWithExtensionSpec;
use LogicException;

/**
 * The Tags section gives access to all of the validation rules are are specific to an HTML element.
 *
 * @package ampproject/amp-toolbox
 *
 * @method Tag parentCurrent()
 */
final class Tags implements IterableSection
{
    use Iteration {
        Iteration::current as parentCurrent;
    }

    /**
     * Mapping of tag ID to tag implementation.
     *
     * @var array<string>
     */
    const TAGS = [
        Tag\HtmlDoctype::ID => Tag\HtmlDoctype::class,
        Tag\HtmlDoctypeAmp4ads::ID => Tag\HtmlDoctypeAmp4ads::class,
        Tag\Html::ID => Tag\Html::class,
        Tag\HtmlTransformed::ID => Tag\HtmlTransformed::class,
        Tag\Head::ID => Tag\Head::class,
        Tag\Title::ID => Tag\Title::class,
        Tag\TitleAmp4email::ID => Tag\TitleAmp4email::class,
        Tag\Base::ID => Tag\Base::class,
        Tag\LinkRel::ID => Tag\LinkRel::class,
        Tag\LinkRelCanonical::ID => Tag\LinkRelCanonical::class,
        Tag\LinkRelManifest::ID => Tag\LinkRelManifest::class,
        Tag\LinkRelModulepreload::ID => Tag\LinkRelModulepreload::class,
        Tag\LinkRelPreload::ID => Tag\LinkRelPreload::class,
        Tag\LinkRelStylesheetForFonts::ID => Tag\LinkRelStylesheetForFonts::class,
        Tag\LinkItempropSameas::ID => Tag\LinkItempropSameas::class,
        Tag\LinkItemprop::ID => Tag\LinkItemprop::class,
        Tag\LinkProperty::ID => Tag\LinkProperty::class,
        Tag\MetaCharsetUtf8::ID => Tag\MetaCharsetUtf8::class,
        Tag\MetaNameViewport::ID => Tag\MetaNameViewport::class,
        Tag\MetaHttpEquivXUaCompatible::ID => Tag\MetaHttpEquivXUaCompatible::class,
        Tag\MetaNameAppleItunesApp::ID => Tag\MetaNameAppleItunesApp::class,
        Tag\MetaNameAmpExperimentsOptIn::ID => Tag\MetaNameAmpExperimentsOptIn::class,
        Tag\MetaNameAmp3pIframeSrc::ID => Tag\MetaNameAmp3pIframeSrc::class,
        Tag\MetaNameAmpConsentBlocking::ID => Tag\MetaNameAmpConsentBlocking::class,
        Tag\MetaNameAmpExperimentToken::ID => Tag\MetaNameAmpExperimentToken::class,
        Tag\MetaNameAmpLinkVariableAllowedOrigin::ID => Tag\MetaNameAmpLinkVariableAllowedOrigin::class,
        Tag\MetaNameAmpGoogleClientidIdApi::ID => Tag\MetaNameAmpGoogleClientidIdApi::class,
        Tag\MetaNameAmpAdDoubleclickSra::ID => Tag\MetaNameAmpAdDoubleclickSra::class,
        Tag\MetaNameAmpListLoadMore::ID => Tag\MetaNameAmpListLoadMore::class,
        Tag\MetaNameAmpRecaptchaInput::ID => Tag\MetaNameAmpRecaptchaInput::class,
        Tag\MetaNameAmpScriptSrc::ID => Tag\MetaNameAmpScriptSrc::class,
        Tag\MetaNameAmp4adsId::ID => Tag\MetaNameAmp4adsId::class,
        Tag\MetaNameAndContent::ID => Tag\MetaNameAndContent::class,
        Tag\MetaHttpEquivContentType::ID => Tag\MetaHttpEquivContentType::class,
        Tag\MetaHttpEquivContentLanguage::ID => Tag\MetaHttpEquivContentLanguage::class,
        Tag\MetaHttpEquivPicsLabel::ID => Tag\MetaHttpEquivPicsLabel::class,
        Tag\MetaHttpEquivImagetoolbar::ID => Tag\MetaHttpEquivImagetoolbar::class,
        Tag\MetaHttpEquivContentStyleType::ID => Tag\MetaHttpEquivContentStyleType::class,
        Tag\MetaHttpEquivContentScriptType::ID => Tag\MetaHttpEquivContentScriptType::class,
        Tag\MetaHttpEquivOriginTrial::ID => Tag\MetaHttpEquivOriginTrial::class,
        Tag\MetaHttpEquivResourceType::ID => Tag\MetaHttpEquivResourceType::class,
        Tag\MetaHttpEquivXDnsPrefetchControl::ID => Tag\MetaHttpEquivXDnsPrefetchControl::class,
        Tag\MetaNameAmpAdEnableRefresh::ID => Tag\MetaNameAmpAdEnableRefresh::class,
        Tag\MetaNameAmpToAmpNavigation::ID => Tag\MetaNameAmpToAmpNavigation::class,
        Tag\MetaNameAmpCtaType::ID => Tag\MetaNameAmpCtaType::class,
        Tag\MetaNameAmpCtaUrl::ID => Tag\MetaNameAmpCtaUrl::class,
        Tag\MetaNameAmpCtaLandingPageType::ID => Tag\MetaNameAmpCtaLandingPageType::class,
        Tag\MetaNameAmp4adsVars::ID => Tag\MetaNameAmp4adsVars::class,
        Tag\Body::ID => Tag\Body::class,
        Tag\Article::ID => Tag\Article::class,
        Tag\Section::ID => Tag\Section::class,
        Tag\SectionAmp4email::ID => Tag\SectionAmp4email::class,
        Tag\Nav::ID => Tag\Nav::class,
        Tag\Aside::ID => Tag\Aside::class,
        Tag\H1::ID => Tag\H1::class,
        Tag\H2::ID => Tag\H2::class,
        Tag\H3::ID => Tag\H3::class,
        Tag\H4::ID => Tag\H4::class,
        Tag\H5::ID => Tag\H5::class,
        Tag\H6::ID => Tag\H6::class,
        Tag\Header::ID => Tag\Header::class,
        Tag\Footer::ID => Tag\Footer::class,
        Tag\Address::ID => Tag\Address::class,
        Tag\P::ID => Tag\P::class,
        Tag\Hr::ID => Tag\Hr::class,
        Tag\Pre::ID => Tag\Pre::class,
        Tag\Blockquote::ID => Tag\Blockquote::class,
        Tag\Ol::ID => Tag\Ol::class,
        Tag\Ul::ID => Tag\Ul::class,
        Tag\Li::ID => Tag\Li::class,
        Tag\Dl::ID => Tag\Dl::class,
        Tag\Dt::ID => Tag\Dt::class,
        Tag\Dd::ID => Tag\Dd::class,
        Tag\Figure::ID => Tag\Figure::class,
        Tag\Figcaption::ID => Tag\Figcaption::class,
        Tag\Div::ID => Tag\Div::class,
        Tag\Main::ID => Tag\Main::class,
        Tag\A::ID => Tag\A::class,
        Tag\AAmp4email::ID => Tag\AAmp4email::class,
        Tag\Em::ID => Tag\Em::class,
        Tag\Strong::ID => Tag\Strong::class,
        Tag\Small::ID => Tag\Small::class,
        Tag\S::ID => Tag\S::class,
        Tag\Cite::ID => Tag\Cite::class,
        Tag\Q::ID => Tag\Q::class,
        Tag\Dfn::ID => Tag\Dfn::class,
        Tag\Abbr::ID => Tag\Abbr::class,
        Tag\Data::ID => Tag\Data::class,
        Tag\Time::ID => Tag\Time::class,
        Tag\Code::ID => Tag\Code::class,
        Tag\Var_::ID => Tag\Var_::class,
        Tag\Samp::ID => Tag\Samp::class,
        Tag\Kbd::ID => Tag\Kbd::class,
        Tag\Sub::ID => Tag\Sub::class,
        Tag\Sup::ID => Tag\Sup::class,
        Tag\I::ID => Tag\I::class,
        Tag\B::ID => Tag\B::class,
        Tag\U::ID => Tag\U::class,
        Tag\Mark::ID => Tag\Mark::class,
        Tag\Ruby::ID => Tag\Ruby::class,
        Tag\Rb::ID => Tag\Rb::class,
        Tag\Rt::ID => Tag\Rt::class,
        Tag\Rtc::ID => Tag\Rtc::class,
        Tag\Rp::ID => Tag\Rp::class,
        Tag\Bdi::ID => Tag\Bdi::class,
        Tag\Bdo::ID => Tag\Bdo::class,
        Tag\Span::ID => Tag\Span::class,
        Tag\Br::ID => Tag\Br::class,
        Tag\Wbr::ID => Tag\Wbr::class,
        Tag\Ins::ID => Tag\Ins::class,
        Tag\Del::ID => Tag\Del::class,
        Tag\NoscriptImg::ID => Tag\NoscriptImg::class,
        Tag\Iframe::ID => Tag\Iframe::class,
        Tag\Video::ID => Tag\Video::class,
        Tag\Audio::ID => Tag\Audio::class,
        Tag\Picture::ID => Tag\Picture::class,
        Tag\PictureSource::ID => Tag\PictureSource::class,
        Tag\AmpVideoSource::ID => Tag\AmpVideoSource::class,
        Tag\AmpAudioSource::ID => Tag\AmpAudioSource::class,
        Tag\AudioSource::ID => Tag\AudioSource::class,
        Tag\VideoSource::ID => Tag\VideoSource::class,
        Tag\AmpImaVideoSource::ID => Tag\AmpImaVideoSource::class,
        Tag\AudioTrack::ID => Tag\AudioTrack::class,
        Tag\AudioTrackKindSubtitles::ID => Tag\AudioTrackKindSubtitles::class,
        Tag\VideoTrack::ID => Tag\VideoTrack::class,
        Tag\VideoTrackKindSubtitles::ID => Tag\VideoTrackKindSubtitles::class,
        Tag\AmpAudioTrack::ID => Tag\AmpAudioTrack::class,
        Tag\AmpAudioTrackKindSubtitles::ID => Tag\AmpAudioTrackKindSubtitles::class,
        Tag\AmpVideoTrack::ID => Tag\AmpVideoTrack::class,
        Tag\AmpVideoTrackKindSubtitles::ID => Tag\AmpVideoTrackKindSubtitles::class,
        Tag\AmpImaVideoTrack::ID => Tag\AmpImaVideoTrack::class,
        Tag\AmpImaVideoTrackKindSubtitles::ID => Tag\AmpImaVideoTrackKindSubtitles::class,
        Tag\Table::ID => Tag\Table::class,
        Tag\Caption::ID => Tag\Caption::class,
        Tag\Colgroup::ID => Tag\Colgroup::class,
        Tag\Col::ID => Tag\Col::class,
        Tag\Tbody::ID => Tag\Tbody::class,
        Tag\Thead::ID => Tag\Thead::class,
        Tag\Tfoot::ID => Tag\Tfoot::class,
        Tag\Tr::ID => Tag\Tr::class,
        Tag\Td::ID => Tag\Td::class,
        Tag\Th::ID => Tag\Th::class,
        Tag\FormMethodGet::ID => Tag\FormMethodGet::class,
        Tag\FormMethodPost::ID => Tag\FormMethodPost::class,
        Tag\FormMethodGetAmp4email::ID => Tag\FormMethodGetAmp4email::class,
        Tag\FormMethodPostAmp4email::ID => Tag\FormMethodPostAmp4email::class,
        Tag\FormDivVerifyError::ID => Tag\FormDivVerifyError::class,
        Tag\FormDivVerifyErrorTemplate::ID => Tag\FormDivVerifyErrorTemplate::class,
        Tag\FormDivSubmitting::ID => Tag\FormDivSubmitting::class,
        Tag\FormDivSubmittingTemplate::ID => Tag\FormDivSubmittingTemplate::class,
        Tag\FormDivSubmitSuccess::ID => Tag\FormDivSubmitSuccess::class,
        Tag\FormDivSubmitSuccessTemplate::ID => Tag\FormDivSubmitSuccessTemplate::class,
        Tag\FormDivSubmitError::ID => Tag\FormDivSubmitError::class,
        Tag\FormDivSubmitErrorTemplate::ID => Tag\FormDivSubmitErrorTemplate::class,
        Tag\Label::ID => Tag\Label::class,
        Tag\Input::ID => Tag\Input::class,
        Tag\InputTypeFile::ID => Tag\InputTypeFile::class,
        Tag\InputTypePassword::ID => Tag\InputTypePassword::class,
        Tag\Button::ID => Tag\Button::class,
        Tag\AmpAppBannerButtonOpenButton::ID => Tag\AmpAppBannerButtonOpenButton::class,
        Tag\Select::ID => Tag\Select::class,
        Tag\Datalist::ID => Tag\Datalist::class,
        Tag\Optgroup::ID => Tag\Optgroup::class,
        Tag\Option::ID => Tag\Option::class,
        Tag\Textarea::ID => Tag\Textarea::class,
        Tag\Output::ID => Tag\Output::class,
        Tag\Progress::ID => Tag\Progress::class,
        Tag\Meter::ID => Tag\Meter::class,
        Tag\Fieldset::ID => Tag\Fieldset::class,
        Tag\Legend::ID => Tag\Legend::class,
        Tag\Details::ID => Tag\Details::class,
        Tag\Summary::ID => Tag\Summary::class,
        Tag\AmphtmlEngineScript::ID => Tag\AmphtmlEngineScript::class,
        Tag\AmphtmlEngineScriptLts::ID => Tag\AmphtmlEngineScriptLts::class,
        Tag\AmphtmlModuleEngineScript::ID => Tag\AmphtmlModuleEngineScript::class,
        Tag\AmphtmlNomoduleEngineScript::ID => Tag\AmphtmlNomoduleEngineScript::class,
        Tag\AmphtmlModuleLtsEngineScript::ID => Tag\AmphtmlModuleLtsEngineScript::class,
        Tag\AmphtmlNomoduleLtsEngineScript::ID => Tag\AmphtmlNomoduleLtsEngineScript::class,
        Tag\AmphtmlEngineScriptAmp4email::ID => Tag\AmphtmlEngineScriptAmp4email::class,
        Tag\Amp4adsEngineScript::ID => Tag\Amp4adsEngineScript::class,
        Tag\ScriptTypeApplicationLdJson::ID => Tag\ScriptTypeApplicationLdJson::class,
        Tag\ScriptIdAmpRtc::ID => Tag\ScriptIdAmpRtc::class,
        Tag\AmpImaVideoScriptTypeApplicationJson::ID => Tag\AmpImaVideoScriptTypeApplicationJson::class,
        Tag\ScriptAmpOnerrorV0JsOrV0Mjs::ID => Tag\ScriptAmpOnerrorV0JsOrV0Mjs::class,
        Tag\ScriptAmpOnerrorV0Js::ID => Tag\ScriptAmpOnerrorV0Js::class,
        Tag\NoscriptEnclosureForBoilerplate::ID => Tag\NoscriptEnclosureForBoilerplate::class,
        Tag\NoscriptEnclosureForBoilerplateTransformed::ID => Tag\NoscriptEnclosureForBoilerplateTransformed::class,
        Tag\Noscript::ID => Tag\Noscript::class,
        Tag\Acronym::ID => Tag\Acronym::class,
        Tag\Big::ID => Tag\Big::class,
        Tag\Center::ID => Tag\Center::class,
        Tag\Dir::ID => Tag\Dir::class,
        Tag\Hgroup::ID => Tag\Hgroup::class,
        Tag\Listing::ID => Tag\Listing::class,
        Tag\Multicol::ID => Tag\Multicol::class,
        Tag\Nextid::ID => Tag\Nextid::class,
        Tag\Nobr::ID => Tag\Nobr::class,
        Tag\Spacer::ID => Tag\Spacer::class,
        Tag\Strike::ID => Tag\Strike::class,
        Tag\Tt::ID => Tag\Tt::class,
        Tag\Slot::ID => Tag\Slot::class,
        Tag\OP::ID => Tag\OP::class,
        Tag\AmpImg::ID => Tag\AmpImg::class,
        Tag\AmpImgTransformed::ID => Tag\AmpImgTransformed::class,
        Tag\AmpImgAmp4email::ID => Tag\AmpImgAmp4email::class,
        Tag\AmpLayout::ID => Tag\AmpLayout::class,
        Tag\AmpPixel::ID => Tag\AmpPixel::class,
        Tag\IAmphtmlSizerResponsive::ID => Tag\IAmphtmlSizerResponsive::class,
        Tag\IAmphtmlSizerIntrinsic::ID => Tag\IAmphtmlSizerIntrinsic::class,
        Tag\ImgIAmphtmlIntrinsicSizer::ID => Tag\ImgIAmphtmlIntrinsicSizer::class,
        Tag\AmpImgImgTransformed::ID => Tag\AmpImgImgTransformed::class,
        Tag\AmpImgImgPlaceholderTransformed::ID => Tag\AmpImgImgPlaceholderTransformed::class,
        Tag\StyleAmpCustomLengthCheck::ID => Tag\StyleAmpCustomLengthCheck::class,
        Tag\StyleAmpCustom::ID => Tag\StyleAmpCustom::class,
        Tag\StyleAmpCustomAmp4ads::ID => Tag\StyleAmpCustomAmp4ads::class,
        Tag\StyleAmpCustomAmp4email::ID => Tag\StyleAmpCustomAmp4email::class,
        Tag\StyleAmpCustomCssStrict::ID => Tag\StyleAmpCustomCssStrict::class,
        Tag\HeadStyleAmpBoilerplate::ID => Tag\HeadStyleAmpBoilerplate::class,
        Tag\HeadStyleAmpBoilerplateTransformed::ID => Tag\HeadStyleAmpBoilerplateTransformed::class,
        Tag\HeadStyleAmp4adsBoilerplate::ID => Tag\HeadStyleAmp4adsBoilerplate::class,
        Tag\HeadStyleAmp4emailBoilerplate::ID => Tag\HeadStyleAmp4emailBoilerplate::class,
        Tag\NoscriptStyleAmpBoilerplate::ID => Tag\NoscriptStyleAmpBoilerplate::class,
        Tag\NoscriptStyleAmpBoilerplateTransformed::ID => Tag\NoscriptStyleAmpBoilerplateTransformed::class,
        Tag\StyleAmpKeyframes::ID => Tag\StyleAmpKeyframes::class,
        Tag\StyleAmpRuntimeTransformed::ID => Tag\StyleAmpRuntimeTransformed::class,
        Tag\G::ID => Tag\G::class,
        Tag\Glyph::ID => Tag\Glyph::class,
        Tag\Glyphref::ID => Tag\Glyphref::class,
        Tag\Image::ID => Tag\Image::class,
        Tag\Marker::ID => Tag\Marker::class,
        Tag\Metadata::ID => Tag\Metadata::class,
        Tag\Path::ID => Tag\Path::class,
        Tag\Solidcolor::ID => Tag\Solidcolor::class,
        Tag\Svg::ID => Tag\Svg::class,
        Tag\Switch_::ID => Tag\Switch_::class,
        Tag\View::ID => Tag\View::class,
        Tag\Circle::ID => Tag\Circle::class,
        Tag\Ellipse::ID => Tag\Ellipse::class,
        Tag\Line::ID => Tag\Line::class,
        Tag\Polygon::ID => Tag\Polygon::class,
        Tag\Polyline::ID => Tag\Polyline::class,
        Tag\Rect::ID => Tag\Rect::class,
        Tag\Text::ID => Tag\Text::class,
        Tag\Textpath::ID => Tag\Textpath::class,
        Tag\Tref::ID => Tag\Tref::class,
        Tag\Tspan::ID => Tag\Tspan::class,
        Tag\Clippath::ID => Tag\Clippath::class,
        Tag\Filter::ID => Tag\Filter::class,
        Tag\Hkern::ID => Tag\Hkern::class,
        Tag\Lineargradient::ID => Tag\Lineargradient::class,
        Tag\Mask::ID => Tag\Mask::class,
        Tag\Pattern::ID => Tag\Pattern::class,
        Tag\Radialgradient::ID => Tag\Radialgradient::class,
        Tag\LineargradientStop::ID => Tag\LineargradientStop::class,
        Tag\RadialgradientStop::ID => Tag\RadialgradientStop::class,
        Tag\Vkern::ID => Tag\Vkern::class,
        Tag\Defs::ID => Tag\Defs::class,
        Tag\Symbol::ID => Tag\Symbol::class,
        Tag\Use_::ID => Tag\Use_::class,
        Tag\Feblend::ID => Tag\Feblend::class,
        Tag\Fecolormatrix::ID => Tag\Fecolormatrix::class,
        Tag\Fecomponenttransfer::ID => Tag\Fecomponenttransfer::class,
        Tag\Fecomposite::ID => Tag\Fecomposite::class,
        Tag\Feconvolvematrix::ID => Tag\Feconvolvematrix::class,
        Tag\Fediffuselighting::ID => Tag\Fediffuselighting::class,
        Tag\Fedisplacementmap::ID => Tag\Fedisplacementmap::class,
        Tag\Fedistantlight::ID => Tag\Fedistantlight::class,
        Tag\Fedropshadow::ID => Tag\Fedropshadow::class,
        Tag\Feflood::ID => Tag\Feflood::class,
        Tag\Fefunca::ID => Tag\Fefunca::class,
        Tag\Fefuncb::ID => Tag\Fefuncb::class,
        Tag\Fefuncg::ID => Tag\Fefuncg::class,
        Tag\Fefuncr::ID => Tag\Fefuncr::class,
        Tag\Fegaussianblur::ID => Tag\Fegaussianblur::class,
        Tag\Femerge::ID => Tag\Femerge::class,
        Tag\Femergenode::ID => Tag\Femergenode::class,
        Tag\Femorphology::ID => Tag\Femorphology::class,
        Tag\Feoffset::ID => Tag\Feoffset::class,
        Tag\Fepointlight::ID => Tag\Fepointlight::class,
        Tag\Fespecularlighting::ID => Tag\Fespecularlighting::class,
        Tag\Fespotlight::ID => Tag\Fespotlight::class,
        Tag\Fetile::ID => Tag\Fetile::class,
        Tag\Feturbulence::ID => Tag\Feturbulence::class,
        Tag\Desc::ID => Tag\Desc::class,
        Tag\SvgTitle::ID => Tag\SvgTitle::class,
        Tag\ScriptAmp3dGltf::ID => Tag\ScriptAmp3dGltf::class,
        Tag\Amp3dGltf::ID => Tag\Amp3dGltf::class,
        Tag\ScriptAmp3qPlayer::ID => Tag\ScriptAmp3qPlayer::class,
        Tag\Amp3qPlayer::ID => Tag\Amp3qPlayer::class,
        Tag\ScriptAmpAccessLaterpay::ID => Tag\ScriptAmpAccessLaterpay::class,
        Tag\ScriptAmpAccessPoool::ID => Tag\ScriptAmpAccessPoool::class,
        Tag\ScriptAmpAccessScroll::ID => Tag\ScriptAmpAccessScroll::class,
        Tag\ScriptAmpAccess::ID => Tag\ScriptAmpAccess::class,
        Tag\AmpAccessExtensionJsonScript::ID => Tag\AmpAccessExtensionJsonScript::class,
        Tag\ScriptAmpAccordion::ID => Tag\ScriptAmpAccordion::class,
        Tag\ScriptAmpAccordion2::ID => Tag\ScriptAmpAccordion2::class,
        Tag\ScriptCustomElementAmpAccordionAmp4email::ID => Tag\ScriptCustomElementAmpAccordionAmp4email::class,
        Tag\AmpAccordion::ID => Tag\AmpAccordion::class,
        Tag\AmpAccordionSection::ID => Tag\AmpAccordionSection::class,
        Tag\ScriptAmpActionMacro::ID => Tag\ScriptAmpActionMacro::class,
        Tag\AmpActionMacro::ID => Tag\AmpActionMacro::class,
        Tag\ScriptAmpAdCustom::ID => Tag\ScriptAmpAdCustom::class,
        Tag\AmpAdCustom::ID => Tag\AmpAdCustom::class,
        Tag\ScriptAmpAdExit::ID => Tag\ScriptAmpAdExit::class,
        Tag\AmpAdExit::ID => Tag\AmpAdExit::class,
        Tag\AmpAdExitConfigurationJson::ID => Tag\AmpAdExitConfigurationJson::class,
        Tag\AmpAdExtensionScript::ID => Tag\AmpAdExtensionScript::class,
        Tag\AmpAd::ID => Tag\AmpAd::class,
        Tag\AmpAdWithTypeCustom::ID => Tag\AmpAdWithTypeCustom::class,
        Tag\AmpAdWithDataMultiSizeAttribute::ID => Tag\AmpAdWithDataMultiSizeAttribute::class,
        Tag\AmpAdWithDataEnableRefreshAttribute::ID => Tag\AmpAdWithDataEnableRefreshAttribute::class,
        Tag\AmpEmbed::ID => Tag\AmpEmbed::class,
        Tag\AmpEmbedWithDataMultiSizeAttribute::ID => Tag\AmpEmbedWithDataMultiSizeAttribute::class,
        Tag\ScriptAmpAddthis::ID => Tag\ScriptAmpAddthis::class,
        Tag\AmpAddthis::ID => Tag\AmpAddthis::class,
        Tag\ScriptAmpAnalytics::ID => Tag\ScriptAmpAnalytics::class,
        Tag\AmpAnalyticsExtensionJsonScript::ID => Tag\AmpAnalyticsExtensionJsonScript::class,
        Tag\AmpAnalytics::ID => Tag\AmpAnalytics::class,
        Tag\ScriptAmpAnim::ID => Tag\ScriptAmpAnim::class,
        Tag\AmpAnimExtensionScriptAmp4email::ID => Tag\AmpAnimExtensionScriptAmp4email::class,
        Tag\AmpAnim::ID => Tag\AmpAnim::class,
        Tag\AmpAnimAmp4email::ID => Tag\AmpAnimAmp4email::class,
        Tag\ScriptAmpAnimation::ID => Tag\ScriptAmpAnimation::class,
        Tag\AmpAnimationExtensionJsonScript::ID => Tag\AmpAnimationExtensionJsonScript::class,
        Tag\AmpAnimation::ID => Tag\AmpAnimation::class,
        Tag\ScriptAmpApesterMedia::ID => Tag\ScriptAmpApesterMedia::class,
        Tag\AmpApesterMedia::ID => Tag\AmpApesterMedia::class,
        Tag\ScriptAmpAppBanner::ID => Tag\ScriptAmpAppBanner::class,
        Tag\AmpAppBanner::ID => Tag\AmpAppBanner::class,
        Tag\ScriptAmpAudio::ID => Tag\ScriptAmpAudio::class,
        Tag\AmpAudio::ID => Tag\AmpAudio::class,
        Tag\AmpStoryAmpAudio::ID => Tag\AmpStoryAmpAudio::class,
        Tag\AmpAudioA4a::ID => Tag\AmpAudioA4a::class,
        Tag\ScriptAmpAutoAds::ID => Tag\ScriptAmpAutoAds::class,
        Tag\AmpAutoAds::ID => Tag\AmpAutoAds::class,
        Tag\ScriptAmpAutocomplete::ID => Tag\ScriptAmpAutocomplete::class,
        Tag\ScriptCustomElementAmpAutocompleteAmp4email::ID => Tag\ScriptCustomElementAmpAutocompleteAmp4email::class,
        Tag\AmpAutocomplete::ID => Tag\AmpAutocomplete::class,
        Tag\AmpAutocompleteAmp4email::ID => Tag\AmpAutocompleteAmp4email::class,
        Tag\AmpAutocompleteInput::ID => Tag\AmpAutocompleteInput::class,
        Tag\AmpAutocompleteJson::ID => Tag\AmpAutocompleteJson::class,
        Tag\ScriptAmpBaseCarousel::ID => Tag\ScriptAmpBaseCarousel::class,
        Tag\AmpBaseCarousel::ID => Tag\AmpBaseCarousel::class,
        Tag\AmpBaseCarouselLightbox::ID => Tag\AmpBaseCarouselLightbox::class,
        Tag\AmpBaseCarouselLightboxLightboxExclude::ID => Tag\AmpBaseCarouselLightboxLightboxExclude::class,
        Tag\AmpBaseCarouselLightboxChild::ID => Tag\AmpBaseCarouselLightboxChild::class,
        Tag\ScriptAmpBeopinion::ID => Tag\ScriptAmpBeopinion::class,
        Tag\AmpBeopinion::ID => Tag\AmpBeopinion::class,
        Tag\ScriptAmpBind::ID => Tag\ScriptAmpBind::class,
        Tag\ScriptCustomElementAmpBindAmp4email::ID => Tag\ScriptCustomElementAmpBindAmp4email::class,
        Tag\AmpBindExtensionJsonScript::ID => Tag\AmpBindExtensionJsonScript::class,
        Tag\AmpState::ID => Tag\AmpState::class,
        Tag\AmpStateAmp4email::ID => Tag\AmpStateAmp4email::class,
        Tag\AmpBindMacro::ID => Tag\AmpBindMacro::class,
        Tag\ScriptAmpBodymovinAnimation::ID => Tag\ScriptAmpBodymovinAnimation::class,
        Tag\AmpBodymovinAnimation::ID => Tag\AmpBodymovinAnimation::class,
        Tag\ScriptAmpBridPlayer::ID => Tag\ScriptAmpBridPlayer::class,
        Tag\AmpBridPlayer::ID => Tag\AmpBridPlayer::class,
        Tag\ScriptAmpBrightcove::ID => Tag\ScriptAmpBrightcove::class,
        Tag\AmpBrightcove::ID => Tag\AmpBrightcove::class,
        Tag\ScriptAmpBysideContent::ID => Tag\ScriptAmpBysideContent::class,
        Tag\AmpBysideContent::ID => Tag\AmpBysideContent::class,
        Tag\ScriptAmpCacheUrl::ID => Tag\ScriptAmpCacheUrl::class,
        Tag\ScriptAmpCallTracking::ID => Tag\ScriptAmpCallTracking::class,
        Tag\AmpCallTracking::ID => Tag\AmpCallTracking::class,
        Tag\ScriptAmpCarousel::ID => Tag\ScriptAmpCarousel::class,
        Tag\ScriptCustomElementAmpCarouselAmp4email::ID => Tag\ScriptCustomElementAmpCarouselAmp4email::class,
        Tag\AmpCarousel::ID => Tag\AmpCarousel::class,
        Tag\AmpCarouselLightbox::ID => Tag\AmpCarouselLightbox::class,
        Tag\AmpCarouselLightboxLightboxExclude::ID => Tag\AmpCarouselLightboxLightboxExclude::class,
        Tag\AmpCarouselLightboxChild::ID => Tag\AmpCarouselLightboxChild::class,
        Tag\ScriptAmpConnatixPlayer::ID => Tag\ScriptAmpConnatixPlayer::class,
        Tag\AmpConnatixPlayer::ID => Tag\AmpConnatixPlayer::class,
        Tag\ScriptAmpConsent::ID => Tag\ScriptAmpConsent::class,
        Tag\AmpConsentExtensionJsonScript::ID => Tag\AmpConsentExtensionJsonScript::class,
        Tag\AmpConsent::ID => Tag\AmpConsent::class,
        Tag\AmpConsentType::ID => Tag\AmpConsentType::class,
        Tag\ScriptAmpDailymotion::ID => Tag\ScriptAmpDailymotion::class,
        Tag\AmpDailymotion::ID => Tag\AmpDailymotion::class,
        Tag\ScriptAmpDateCountdown::ID => Tag\ScriptAmpDateCountdown::class,
        Tag\AmpDateCountdown::ID => Tag\AmpDateCountdown::class,
        Tag\ScriptAmpDateDisplay::ID => Tag\ScriptAmpDateDisplay::class,
        Tag\AmpDateDisplay::ID => Tag\AmpDateDisplay::class,
        Tag\ScriptAmpDatePicker::ID => Tag\ScriptAmpDatePicker::class,
        Tag\AmpDatePickerTypeSingleModeStatic::ID => Tag\AmpDatePickerTypeSingleModeStatic::class,
        Tag\AmpDatePickerTypeSingleModeOverlay::ID => Tag\AmpDatePickerTypeSingleModeOverlay::class,
        Tag\AmpDatePickerTypeRangeModeStatic::ID => Tag\AmpDatePickerTypeRangeModeStatic::class,
        Tag\AmpDatePickerTypeRangeModeOverlay::ID => Tag\AmpDatePickerTypeRangeModeOverlay::class,
        Tag\AmpDatePickerTemplateDateTemplate::ID => Tag\AmpDatePickerTemplateDateTemplate::class,
        Tag\AmpDatePickerTemplateInfoTemplate::ID => Tag\AmpDatePickerTemplateInfoTemplate::class,
        Tag\ScriptAmpDelightPlayer::ID => Tag\ScriptAmpDelightPlayer::class,
        Tag\AmpDelightPlayer::ID => Tag\AmpDelightPlayer::class,
        Tag\ScriptAmpDynamicCssClasses::ID => Tag\ScriptAmpDynamicCssClasses::class,
        Tag\ScriptAmpEmbedlyCard::ID => Tag\ScriptAmpEmbedlyCard::class,
        Tag\AmpEmbedlyCard::ID => Tag\AmpEmbedlyCard::class,
        Tag\AmpEmbedlyKey::ID => Tag\AmpEmbedlyKey::class,
        Tag\ScriptAmpExperiment::ID => Tag\ScriptAmpExperiment::class,
        Tag\AmpExperimentExtensionJsonScript::ID => Tag\AmpExperimentExtensionJsonScript::class,
        Tag\AmpExperiment::ID => Tag\AmpExperiment::class,
        Tag\ScriptAmpFacebookComments::ID => Tag\ScriptAmpFacebookComments::class,
        Tag\AmpFacebookComments::ID => Tag\AmpFacebookComments::class,
        Tag\ScriptAmpFacebookLike::ID => Tag\ScriptAmpFacebookLike::class,
        Tag\AmpFacebookLike::ID => Tag\AmpFacebookLike::class,
        Tag\ScriptAmpFacebookPage::ID => Tag\ScriptAmpFacebookPage::class,
        Tag\AmpFacebookPage::ID => Tag\AmpFacebookPage::class,
        Tag\ScriptAmpFacebook::ID => Tag\ScriptAmpFacebook::class,
        Tag\AmpFacebook::ID => Tag\AmpFacebook::class,
        Tag\ScriptAmpFitText::ID => Tag\ScriptAmpFitText::class,
        Tag\ScriptAmpFitText2::ID => Tag\ScriptAmpFitText2::class,
        Tag\ScriptCustomElementAmpFitTextAmp4email::ID => Tag\ScriptCustomElementAmpFitTextAmp4email::class,
        Tag\AmpFitText::ID => Tag\AmpFitText::class,
        Tag\ScriptAmpFont::ID => Tag\ScriptAmpFont::class,
        Tag\AmpFont::ID => Tag\AmpFont::class,
        Tag\ScriptAmpForm::ID => Tag\ScriptAmpForm::class,
        Tag\ScriptCustomElementAmpFormAmp4email::ID => Tag\ScriptCustomElementAmpFormAmp4email::class,
        Tag\ScriptAmpFxCollection::ID => Tag\ScriptAmpFxCollection::class,
        Tag\ScriptAmpFxFlyingCarpet::ID => Tag\ScriptAmpFxFlyingCarpet::class,
        Tag\AmpFxFlyingCarpet::ID => Tag\AmpFxFlyingCarpet::class,
        Tag\ScriptAmpGeo::ID => Tag\ScriptAmpGeo::class,
        Tag\AmpGeo::ID => Tag\AmpGeo::class,
        Tag\AmpGeoExtensionJsonScript::ID => Tag\AmpGeoExtensionJsonScript::class,
        Tag\ScriptAmpGfycat::ID => Tag\ScriptAmpGfycat::class,
        Tag\AmpGfycat::ID => Tag\AmpGfycat::class,
        Tag\ScriptAmpGist::ID => Tag\ScriptAmpGist::class,
        Tag\AmpGist::ID => Tag\AmpGist::class,
        Tag\ScriptAmpGoogleAssistantAssistjs::ID => Tag\ScriptAmpGoogleAssistantAssistjs::class,
        Tag\AmpGoogleAssistantAssistjsConfig::ID => Tag\AmpGoogleAssistantAssistjsConfig::class,
        Tag\AmpGoogleAssistantVoiceButton::ID => Tag\AmpGoogleAssistantVoiceButton::class,
        Tag\AmpGoogleAssistantVoiceBar::ID => Tag\AmpGoogleAssistantVoiceBar::class,
        Tag\AmpGoogleAssistantInlineSuggestionBar::ID => Tag\AmpGoogleAssistantInlineSuggestionBar::class,
        Tag\ScriptAmpGoogleDocumentEmbed::ID => Tag\ScriptAmpGoogleDocumentEmbed::class,
        Tag\AmpGoogleDocumentEmbed::ID => Tag\AmpGoogleDocumentEmbed::class,
        Tag\ScriptAmpGwdAnimation::ID => Tag\ScriptAmpGwdAnimation::class,
        Tag\AmpGwdAnimation::ID => Tag\AmpGwdAnimation::class,
        Tag\ScriptAmpHulu::ID => Tag\ScriptAmpHulu::class,
        Tag\AmpHulu::ID => Tag\AmpHulu::class,
        Tag\ScriptAmpIframe::ID => Tag\ScriptAmpIframe::class,
        Tag\AmpIframe::ID => Tag\AmpIframe::class,
        Tag\ScriptAmpIframely::ID => Tag\ScriptAmpIframely::class,
        Tag\AmpIframely::ID => Tag\AmpIframely::class,
        Tag\ScriptAmpImaVideo::ID => Tag\ScriptAmpImaVideo::class,
        Tag\AmpImaVideo::ID => Tag\AmpImaVideo::class,
        Tag\ScriptAmpImageLightbox::ID => Tag\ScriptAmpImageLightbox::class,
        Tag\ScriptCustomElementAmpImageLightboxAmp4email::ID => Tag\ScriptCustomElementAmpImageLightboxAmp4email::class,
        Tag\AmpImageLightbox::ID => Tag\AmpImageLightbox::class,
        Tag\ScriptAmpImageSlider::ID => Tag\ScriptAmpImageSlider::class,
        Tag\AmpImageSlider::ID => Tag\AmpImageSlider::class,
        Tag\AmpImageSliderTransformed::ID => Tag\AmpImageSliderTransformed::class,
        Tag\AmpImageSliderDivFirst::ID => Tag\AmpImageSliderDivFirst::class,
        Tag\AmpImageSliderDivSecond::ID => Tag\AmpImageSliderDivSecond::class,
        Tag\ScriptAmpImgur::ID => Tag\ScriptAmpImgur::class,
        Tag\AmpImgur::ID => Tag\AmpImgur::class,
        Tag\ScriptAmpInlineGallery::ID => Tag\ScriptAmpInlineGallery::class,
        Tag\AmpInlineGallery::ID => Tag\AmpInlineGallery::class,
        Tag\AmpInlineGalleryPagination::ID => Tag\AmpInlineGalleryPagination::class,
        Tag\AmpInlineGalleryPaginationInset::ID => Tag\AmpInlineGalleryPaginationInset::class,
        Tag\AmpInlineGalleryThumbnails::ID => Tag\AmpInlineGalleryThumbnails::class,
        Tag\ScriptAmpInputmask::ID => Tag\ScriptAmpInputmask::class,
        Tag\InputMaskCustomMask::ID => Tag\InputMaskCustomMask::class,
        Tag\InputMaskPaymentCard::ID => Tag\InputMaskPaymentCard::class,
        Tag\InputMaskDateDdMmYyyy::ID => Tag\InputMaskDateDdMmYyyy::class,
        Tag\InputMaskDateMmDdYyyy::ID => Tag\InputMaskDateMmDdYyyy::class,
        Tag\InputMaskDateMmYy::ID => Tag\InputMaskDateMmYy::class,
        Tag\InputMaskDateYyyyMmDd::ID => Tag\InputMaskDateYyyyMmDd::class,
        Tag\ScriptAmpInstagram::ID => Tag\ScriptAmpInstagram::class,
        Tag\ScriptAmpInstagram2::ID => Tag\ScriptAmpInstagram2::class,
        Tag\AmpInstagram::ID => Tag\AmpInstagram::class,
        Tag\ScriptAmpInstallServiceworker::ID => Tag\ScriptAmpInstallServiceworker::class,
        Tag\AmpInstallServiceworker::ID => Tag\AmpInstallServiceworker::class,
        Tag\ScriptAmpIzlesene::ID => Tag\ScriptAmpIzlesene::class,
        Tag\AmpIzlesene::ID => Tag\AmpIzlesene::class,
        Tag\ScriptAmpJwplayer::ID => Tag\ScriptAmpJwplayer::class,
        Tag\AmpJwplayer::ID => Tag\AmpJwplayer::class,
        Tag\ScriptAmpKalturaPlayer::ID => Tag\ScriptAmpKalturaPlayer::class,
        Tag\AmpKalturaPlayer::ID => Tag\AmpKalturaPlayer::class,
        Tag\ScriptAmpLightboxGallery::ID => Tag\ScriptAmpLightboxGallery::class,
        Tag\ScriptAmpLightbox::ID => Tag\ScriptAmpLightbox::class,
        Tag\ScriptAmpLightbox2::ID => Tag\ScriptAmpLightbox2::class,
        Tag\ScriptCustomElementAmpLightboxAmp4ads::ID => Tag\ScriptCustomElementAmpLightboxAmp4ads::class,
        Tag\ScriptCustomElementAmpLightboxAmp4email::ID => Tag\ScriptCustomElementAmpLightboxAmp4email::class,
        Tag\AmpLightbox::ID => Tag\AmpLightbox::class,
        Tag\AmpLightboxAmp4ads::ID => Tag\AmpLightboxAmp4ads::class,
        Tag\ScriptAmpLinkRewriter::ID => Tag\ScriptAmpLinkRewriter::class,
        Tag\AmpLinkRewriterExtensionJsonScript::ID => Tag\AmpLinkRewriterExtensionJsonScript::class,
        Tag\AmpLinkRewriter::ID => Tag\AmpLinkRewriter::class,
        Tag\ScriptAmpList::ID => Tag\ScriptAmpList::class,
        Tag\ScriptCustomElementAmpListAmp4email::ID => Tag\ScriptCustomElementAmpListAmp4email::class,
        Tag\AmpList::ID => Tag\AmpList::class,
        Tag\AmpListDivFetchError::ID => Tag\AmpListDivFetchError::class,
        Tag\AmpListLoadMore::ID => Tag\AmpListLoadMore::class,
        Tag\AmpListLoadMoreButtonLoadMoreClickable::ID => Tag\AmpListLoadMoreButtonLoadMoreClickable::class,
        Tag\AmpListAmp4email::ID => Tag\AmpListAmp4email::class,
        Tag\ScriptAmpLiveList::ID => Tag\ScriptAmpLiveList::class,
        Tag\AmpLiveList::ID => Tag\AmpLiveList::class,
        Tag\AmpLiveListUpdate::ID => Tag\AmpLiveListUpdate::class,
        Tag\AmpLiveListItems::ID => Tag\AmpLiveListItems::class,
        Tag\AmpLiveListPagination::ID => Tag\AmpLiveListPagination::class,
        Tag\AmpLiveListItemsItem::ID => Tag\AmpLiveListItemsItem::class,
        Tag\ScriptAmpMathml::ID => Tag\ScriptAmpMathml::class,
        Tag\AmpMathml::ID => Tag\AmpMathml::class,
        Tag\ScriptAmpMegaMenu::ID => Tag\ScriptAmpMegaMenu::class,
        Tag\AmpMegaMenu::ID => Tag\AmpMegaMenu::class,
        Tag\AmpMegaMenuNav::ID => Tag\AmpMegaMenuNav::class,
        Tag\AmpMegaMenuAmpList::ID => Tag\AmpMegaMenuAmpList::class,
        Tag\AmpMegaMenuAmpListTemplate::ID => Tag\AmpMegaMenuAmpListTemplate::class,
        Tag\AmpMegaMenuNavUlOl::ID => Tag\AmpMegaMenuNavUlOl::class,
        Tag\AmpMegaMenuNavUlOlLi::ID => Tag\AmpMegaMenuNavUlOlLi::class,
        Tag\AmpMegaMenuItemHeading::ID => Tag\AmpMegaMenuItemHeading::class,
        Tag\AmpMegaMenuItemContent::ID => Tag\AmpMegaMenuItemContent::class,
        Tag\ScriptAmpMegaphone::ID => Tag\ScriptAmpMegaphone::class,
        Tag\AmpMegaphoneDataPlaylist::ID => Tag\AmpMegaphoneDataPlaylist::class,
        Tag\AmpMegaphoneDataEpisode::ID => Tag\AmpMegaphoneDataEpisode::class,
        Tag\ScriptAmpMinuteMediaPlayer::ID => Tag\ScriptAmpMinuteMediaPlayer::class,
        Tag\AmpMinuteMediaPlayer::ID => Tag\AmpMinuteMediaPlayer::class,
        Tag\ScriptAmpMowplayer::ID => Tag\ScriptAmpMowplayer::class,
        Tag\AmpMowplayer::ID => Tag\AmpMowplayer::class,
        Tag\ScriptAmpMraid::ID => Tag\ScriptAmpMraid::class,
        Tag\ScriptAmpMustache::ID => Tag\ScriptAmpMustache::class,
        Tag\ScriptCustomTemplateAmpMustacheAmp4ads::ID => Tag\ScriptCustomTemplateAmpMustacheAmp4ads::class,
        Tag\ScriptCustomTemplateAmpMustacheAmp4email::ID => Tag\ScriptCustomTemplateAmpMustacheAmp4email::class,
        Tag\ScriptTypeTextPlain::ID => Tag\ScriptTypeTextPlain::class,
        Tag\ScriptTypeTextPlainAmp4email::ID => Tag\ScriptTypeTextPlainAmp4email::class,
        Tag\Template::ID => Tag\Template::class,
        Tag\TemplateAmp4email::ID => Tag\TemplateAmp4email::class,
        Tag\ScriptAmpNestedMenu::ID => Tag\ScriptAmpNestedMenu::class,
        Tag\AmpNestedMenu::ID => Tag\AmpNestedMenu::class,
        Tag\DivAmpNestedMenu::ID => Tag\DivAmpNestedMenu::class,
        Tag\ButtonAmpNestedMenu::ID => Tag\ButtonAmpNestedMenu::class,
        Tag\H2AmpNestedMenu::ID => Tag\H2AmpNestedMenu::class,
        Tag\H3AmpNestedMenu::ID => Tag\H3AmpNestedMenu::class,
        Tag\H4AmpNestedMenu::ID => Tag\H4AmpNestedMenu::class,
        Tag\H5AmpNestedMenu::ID => Tag\H5AmpNestedMenu::class,
        Tag\H6AmpNestedMenu::ID => Tag\H6AmpNestedMenu::class,
        Tag\SpanAmpNestedMenu::ID => Tag\SpanAmpNestedMenu::class,
        Tag\ScriptAmpNextPage::ID => Tag\ScriptAmpNextPage::class,
        Tag\AmpNextPageScriptTypeApplicationJson::ID => Tag\AmpNextPageScriptTypeApplicationJson::class,
        Tag\AmpNextPageSeparator::ID => Tag\AmpNextPageSeparator::class,
        Tag\AmpNextPageRecommendationBox::ID => Tag\AmpNextPageRecommendationBox::class,
        Tag\AmpNextPageFooter::ID => Tag\AmpNextPageFooter::class,
        Tag\AmpNextPageWithInlineConfig::ID => Tag\AmpNextPageWithInlineConfig::class,
        Tag\AmpNextPageWithSrcAttribute::ID => Tag\AmpNextPageWithSrcAttribute::class,
        Tag\AmpNextPageTypeAdsense::ID => Tag\AmpNextPageTypeAdsense::class,
        Tag\ScriptAmpNexxtvPlayer::ID => Tag\ScriptAmpNexxtvPlayer::class,
        Tag\AmpNexxtvPlayer::ID => Tag\AmpNexxtvPlayer::class,
        Tag\ScriptAmpO2Player::ID => Tag\ScriptAmpO2Player::class,
        Tag\AmpO2Player::ID => Tag\AmpO2Player::class,
        Tag\ScriptAmpOnetapGoogle::ID => Tag\ScriptAmpOnetapGoogle::class,
        Tag\AmpOnetapGoogle::ID => Tag\AmpOnetapGoogle::class,
        Tag\ScriptAmpOoyalaPlayer::ID => Tag\ScriptAmpOoyalaPlayer::class,
        Tag\AmpOoyalaPlayer::ID => Tag\AmpOoyalaPlayer::class,
        Tag\ScriptAmpOrientationObserver::ID => Tag\ScriptAmpOrientationObserver::class,
        Tag\AmpOrientationObserver::ID => Tag\AmpOrientationObserver::class,
        Tag\ScriptAmpPanZoom::ID => Tag\ScriptAmpPanZoom::class,
        Tag\AmpPanZoom::ID => Tag\AmpPanZoom::class,
        Tag\ScriptAmpPinterest::ID => Tag\ScriptAmpPinterest::class,
        Tag\AmpPinterest::ID => Tag\AmpPinterest::class,
        Tag\ScriptAmpPlaybuzz::ID => Tag\ScriptAmpPlaybuzz::class,
        Tag\AmpPlaybuzz::ID => Tag\AmpPlaybuzz::class,
        Tag\ScriptAmpPositionObserver::ID => Tag\ScriptAmpPositionObserver::class,
        Tag\AmpPositionObserver::ID => Tag\AmpPositionObserver::class,
        Tag\ScriptAmpPowrPlayer::ID => Tag\ScriptAmpPowrPlayer::class,
        Tag\AmpPowrPlayer::ID => Tag\AmpPowrPlayer::class,
        Tag\ScriptAmpReachPlayer::ID => Tag\ScriptAmpReachPlayer::class,
        Tag\AmpReachPlayer::ID => Tag\AmpReachPlayer::class,
        Tag\ScriptAmpRecaptchaInput::ID => Tag\ScriptAmpRecaptchaInput::class,
        Tag\AmpRecaptchaInput::ID => Tag\AmpRecaptchaInput::class,
        Tag\ScriptAmpRedbullPlayer::ID => Tag\ScriptAmpRedbullPlayer::class,
        Tag\AmpRedbullPlayer::ID => Tag\AmpRedbullPlayer::class,
        Tag\ScriptAmpReddit::ID => Tag\ScriptAmpReddit::class,
        Tag\AmpReddit::ID => Tag\AmpReddit::class,
        Tag\ScriptAmpRender::ID => Tag\ScriptAmpRender::class,
        Tag\AmpRender::ID => Tag\AmpRender::class,
        Tag\ScriptAmpRiddleQuiz::ID => Tag\ScriptAmpRiddleQuiz::class,
        Tag\AmpRiddleQuiz::ID => Tag\AmpRiddleQuiz::class,
        Tag\ScriptAmpScript::ID => Tag\ScriptAmpScript::class,
        Tag\AmpScriptExtensionLocalScript::ID => Tag\AmpScriptExtensionLocalScript::class,
        Tag\AmpScript::ID => Tag\AmpScript::class,
        Tag\Canvas::ID => Tag\Canvas::class,
        Tag\ScriptAmpSelector::ID => Tag\ScriptAmpSelector::class,
        Tag\ScriptAmpSelector2::ID => Tag\ScriptAmpSelector2::class,
        Tag\ScriptCustomElementAmpSelectorAmp4email::ID => Tag\ScriptCustomElementAmpSelectorAmp4email::class,
        Tag\AmpSelector::ID => Tag\AmpSelector::class,
        Tag\AmpSelectorOption::ID => Tag\AmpSelectorOption::class,
        Tag\AmpSelectorChild::ID => Tag\AmpSelectorChild::class,
        Tag\ScriptAmpSidebar::ID => Tag\ScriptAmpSidebar::class,
        Tag\ScriptCustomElementAmpSidebarAmp4email::ID => Tag\ScriptCustomElementAmpSidebarAmp4email::class,
        Tag\AmpSidebar::ID => Tag\AmpSidebar::class,
        Tag\AmpSidebarAmp4email::ID => Tag\AmpSidebarAmp4email::class,
        Tag\AmpStoryAmpSidebar::ID => Tag\AmpStoryAmpSidebar::class,
        Tag\AmpSidebarNav::ID => Tag\AmpSidebarNav::class,
        Tag\ScriptAmpSkimlinks::ID => Tag\ScriptAmpSkimlinks::class,
        Tag\AmpSkimlinks::ID => Tag\AmpSkimlinks::class,
        Tag\ScriptAmpSlides::ID => Tag\ScriptAmpSlides::class,
        Tag\ScriptAmpSmartlinks::ID => Tag\ScriptAmpSmartlinks::class,
        Tag\AmpSmartlinks::ID => Tag\AmpSmartlinks::class,
        Tag\ScriptAmpSocialShare::ID => Tag\ScriptAmpSocialShare::class,
        Tag\ScriptAmpSocialShare2::ID => Tag\ScriptAmpSocialShare2::class,
        Tag\AmpSocialShare::ID => Tag\AmpSocialShare::class,
        Tag\ScriptAmpSoundcloud::ID => Tag\ScriptAmpSoundcloud::class,
        Tag\AmpSoundcloud::ID => Tag\AmpSoundcloud::class,
        Tag\ScriptAmpSpringboardPlayer::ID => Tag\ScriptAmpSpringboardPlayer::class,
        Tag\AmpSpringboardPlayer::ID => Tag\AmpSpringboardPlayer::class,
        Tag\ScriptAmpStickyAd::ID => Tag\ScriptAmpStickyAd::class,
        Tag\AmpStickyAd::ID => Tag\AmpStickyAd::class,
        Tag\ScriptAmpStory360::ID => Tag\ScriptAmpStory360::class,
        Tag\AmpStory360::ID => Tag\AmpStory360::class,
        Tag\ScriptAmpStoryAutoAds::ID => Tag\ScriptAmpStoryAutoAds::class,
        Tag\AmpStoryAutoAds::ID => Tag\AmpStoryAutoAds::class,
        Tag\AmpStoryAutoAdsConfigScript::ID => Tag\AmpStoryAutoAdsConfigScript::class,
        Tag\AmpStoryAutoAdsTemplate::ID => Tag\AmpStoryAutoAdsTemplate::class,
        Tag\ScriptAmpStoryAutoAnalytics::ID => Tag\ScriptAmpStoryAutoAnalytics::class,
        Tag\AmpStoryAutoAnalytics::ID => Tag\AmpStoryAutoAnalytics::class,
        Tag\ScriptAmpStoryInteractive::ID => Tag\ScriptAmpStoryInteractive::class,
        Tag\AmpStoryInteractiveQuiz::ID => Tag\AmpStoryInteractiveQuiz::class,
        Tag\AmpStoryInteractivePoll::ID => Tag\AmpStoryInteractivePoll::class,
        Tag\AmpStoryInteractiveBinaryPoll::ID => Tag\AmpStoryInteractiveBinaryPoll::class,
        Tag\AmpStoryInteractiveResults::ID => Tag\AmpStoryInteractiveResults::class,
        Tag\ScriptAmpStoryPanningMedia::ID => Tag\ScriptAmpStoryPanningMedia::class,
        Tag\AmpStoryPanningMedia::ID => Tag\AmpStoryPanningMedia::class,
        Tag\ScriptAmpStoryPlayer::ID => Tag\ScriptAmpStoryPlayer::class,
        Tag\AmpStoryPlayer::ID => Tag\AmpStoryPlayer::class,
        Tag\ImgIAmphtmlIntrinsicSizerAmpStoryPlayer::ID => Tag\ImgIAmphtmlIntrinsicSizerAmpStoryPlayer::class,
        Tag\AmpStoryPlayerImg::ID => Tag\AmpStoryPlayerImg::class,
        Tag\ScriptAmpStory::ID => Tag\ScriptAmpStory::class,
        Tag\AmpStory::ID => Tag\AmpStory::class,
        Tag\AmpStoryPage::ID => Tag\AmpStoryPage::class,
        Tag\AmpStoryGridLayer::ID => Tag\AmpStoryGridLayer::class,
        Tag\AmpStoryGridLayerDefault::ID => Tag\AmpStoryGridLayerDefault::class,
        Tag\AmpStoryGridLayerAnimateIn::ID => Tag\AmpStoryGridLayerAnimateIn::class,
        Tag\AmpStoryBookend::ID => Tag\AmpStoryBookend::class,
        Tag\AmpStoryBookendExtensionJsonScript::ID => Tag\AmpStoryBookendExtensionJsonScript::class,
        Tag\AmpStorySocialShare::ID => Tag\AmpStorySocialShare::class,
        Tag\AmpStorySocialShareExtensionJsonScript::ID => Tag\AmpStorySocialShareExtensionJsonScript::class,
        Tag\AmpStoryConsentExtensionJsonScript::ID => Tag\AmpStoryConsentExtensionJsonScript::class,
        Tag\AmpStoryConsent::ID => Tag\AmpStoryConsent::class,
        Tag\AmpStoryCtaLayer::ID => Tag\AmpStoryCtaLayer::class,
        Tag\AmpExperimentStoryExtensionJsonScript::ID => Tag\AmpExperimentStoryExtensionJsonScript::class,
        Tag\AmpStoryCtaLayerAnimateIn::ID => Tag\AmpStoryCtaLayerAnimateIn::class,
        Tag\AmpStoryPageAttachmentHref::ID => Tag\AmpStoryPageAttachmentHref::class,
        Tag\AmpStoryPageAttachment::ID => Tag\AmpStoryPageAttachment::class,
        Tag\AmpStoryPageOutlink::ID => Tag\AmpStoryPageOutlink::class,
        Tag\AmpStoryAnimationJsonScript::ID => Tag\AmpStoryAnimationJsonScript::class,
        Tag\AmpStoryAnimation::ID => Tag\AmpStoryAnimation::class,
        Tag\MetaNameAmpStoryGeneratorName::ID => Tag\MetaNameAmpStoryGeneratorName::class,
        Tag\MetaNameAmpStoryGeneratorVersion::ID => Tag\MetaNameAmpStoryGeneratorVersion::class,
        Tag\ScriptAmpStreamGallery::ID => Tag\ScriptAmpStreamGallery::class,
        Tag\AmpStreamGallery::ID => Tag\AmpStreamGallery::class,
        Tag\ScriptAmpSubscriptions::ID => Tag\ScriptAmpSubscriptions::class,
        Tag\AmpSubscriptionsExtensionJsonScript::ID => Tag\AmpSubscriptionsExtensionJsonScript::class,
        Tag\ScriptAmpSubscriptionsGoogle::ID => Tag\ScriptAmpSubscriptionsGoogle::class,
        Tag\CryptokeysJsonScript::ID => Tag\CryptokeysJsonScript::class,
        Tag\SubscriptionsSectionContentSwgAmpCacheNonce::ID => Tag\SubscriptionsSectionContentSwgAmpCacheNonce::class,
        Tag\SubscriptionsScriptCiphertext::ID => Tag\SubscriptionsScriptCiphertext::class,
        Tag\SpanSwgAmpCacheNonce::ID => Tag\SpanSwgAmpCacheNonce::class,
        Tag\ScriptAmpTimeago::ID => Tag\ScriptAmpTimeago::class,
        Tag\ScriptCustomElementAmpTimeagoAmp4email::ID => Tag\ScriptCustomElementAmpTimeagoAmp4email::class,
        Tag\AmpTimeago::ID => Tag\AmpTimeago::class,
        Tag\ScriptAmpTruncateText::ID => Tag\ScriptAmpTruncateText::class,
        Tag\AmpTruncateText::ID => Tag\AmpTruncateText::class,
        Tag\ScriptAmpTwitter::ID => Tag\ScriptAmpTwitter::class,
        Tag\ScriptAmpTwitter2::ID => Tag\ScriptAmpTwitter2::class,
        Tag\AmpTwitter::ID => Tag\AmpTwitter::class,
        Tag\ScriptAmpUserNotification::ID => Tag\ScriptAmpUserNotification::class,
        Tag\AmpUserNotification::ID => Tag\AmpUserNotification::class,
        Tag\ScriptAmpVideoDocking::ID => Tag\ScriptAmpVideoDocking::class,
        Tag\ScriptAmpVideoIframe::ID => Tag\ScriptAmpVideoIframe::class,
        Tag\ScriptAmpVideoIframe2::ID => Tag\ScriptAmpVideoIframe2::class,
        Tag\AmpVideoIframe::ID => Tag\AmpVideoIframe::class,
        Tag\AmpVideoIframeTransformed::ID => Tag\AmpVideoIframeTransformed::class,
        Tag\ScriptAmpVideo::ID => Tag\ScriptAmpVideo::class,
        Tag\ScriptAmpVideo2::ID => Tag\ScriptAmpVideo2::class,
        Tag\AmpVideo::ID => Tag\AmpVideo::class,
        Tag\AmpStoryAmpStoryPageAttachmentAmpVideo::ID => Tag\AmpStoryAmpStoryPageAttachmentAmpVideo::class,
        Tag\AmpStoryAmpVideo::ID => Tag\AmpStoryAmpVideo::class,
        Tag\ScriptAmpVimeo::ID => Tag\ScriptAmpVimeo::class,
        Tag\ScriptAmpVimeo2::ID => Tag\ScriptAmpVimeo2::class,
        Tag\AmpVimeo::ID => Tag\AmpVimeo::class,
        Tag\ScriptAmpVine::ID => Tag\ScriptAmpVine::class,
        Tag\AmpVine::ID => Tag\AmpVine::class,
        Tag\ScriptAmpViqeoPlayer::ID => Tag\ScriptAmpViqeoPlayer::class,
        Tag\AmpViqeoPlayer::ID => Tag\AmpViqeoPlayer::class,
        Tag\ScriptAmpVk::ID => Tag\ScriptAmpVk::class,
        Tag\AmpVk::ID => Tag\AmpVk::class,
        Tag\ScriptAmpWebPush::ID => Tag\ScriptAmpWebPush::class,
        Tag\AmpWebPush::ID => Tag\AmpWebPush::class,
        Tag\AmpWebPushWidget::ID => Tag\AmpWebPushWidget::class,
        Tag\ScriptAmpWistiaPlayer::ID => Tag\ScriptAmpWistiaPlayer::class,
        Tag\AmpWistiaPlayer::ID => Tag\AmpWistiaPlayer::class,
        Tag\ScriptAmpYotpo::ID => Tag\ScriptAmpYotpo::class,
        Tag\AmpYotpo::ID => Tag\AmpYotpo::class,
        Tag\ScriptAmpYoutube::ID => Tag\ScriptAmpYoutube::class,
        Tag\ScriptAmpYoutube2::ID => Tag\ScriptAmpYoutube2::class,
        Tag\AmpYoutube::ID => Tag\AmpYoutube::class,
    ];

    /**
     * Mapping of tag name to tag ID or array of tag IDs.
     *
     * This is used to optimize querying by tag name.
     *
     * @var array<string|array<string>>
     */
    const BY_TAG_NAME = [
        Element::A => [
            Tag\A::ID,
            Tag\AAmp4email::ID,
        ],
        Element::ABBR => Tag\Abbr::ID,
        Element::ACRONYM => Tag\Acronym::ID,
        Element::ADDRESS => Tag\Address::ID,
        Extension::_3D_GLTF => Tag\Amp3dGltf::ID,
        Extension::_3Q_PLAYER => Tag\Amp3qPlayer::ID,
        Element::SCRIPT => [
            Tag\AmpAccessExtensionJsonScript::ID,
            Tag\AmpAdExitConfigurationJson::ID,
            Tag\AmpAdExtensionScript::ID,
            Tag\AmpAnalyticsExtensionJsonScript::ID,
            Tag\AmpAnimationExtensionJsonScript::ID,
            Tag\AmpAnimExtensionScriptAmp4email::ID,
            Tag\AmpAutocompleteJson::ID,
            Tag\AmpBindExtensionJsonScript::ID,
            Tag\AmpConsentExtensionJsonScript::ID,
            Tag\AmpExperimentExtensionJsonScript::ID,
            Tag\AmpExperimentStoryExtensionJsonScript::ID,
            Tag\AmpGeoExtensionJsonScript::ID,
            Tag\AmpImaVideoScriptTypeApplicationJson::ID,
            Tag\AmpLinkRewriterExtensionJsonScript::ID,
            Tag\AmpNextPageScriptTypeApplicationJson::ID,
            Tag\AmpScriptExtensionLocalScript::ID,
            Tag\AmpStoryAnimationJsonScript::ID,
            Tag\AmpStoryAutoAdsConfigScript::ID,
            Tag\AmpStoryBookendExtensionJsonScript::ID,
            Tag\AmpStoryConsentExtensionJsonScript::ID,
            Tag\AmpStorySocialShareExtensionJsonScript::ID,
            Tag\AmpSubscriptionsExtensionJsonScript::ID,
            Tag\Amp4adsEngineScript::ID,
            Tag\AmphtmlEngineScript::ID,
            Tag\AmphtmlEngineScriptLts::ID,
            Tag\AmphtmlEngineScriptAmp4email::ID,
            Tag\AmphtmlModuleEngineScript::ID,
            Tag\AmphtmlModuleLtsEngineScript::ID,
            Tag\AmphtmlNomoduleEngineScript::ID,
            Tag\AmphtmlNomoduleLtsEngineScript::ID,
            Tag\CryptokeysJsonScript::ID,
            Tag\ScriptAmpOnerrorV0Js::ID,
            Tag\ScriptAmpOnerrorV0JsOrV0Mjs::ID,
            Tag\ScriptIdAmpRtc::ID,
            Tag\ScriptTypeApplicationLdJson::ID,
            Tag\ScriptTypeTextPlain::ID,
            Tag\ScriptTypeTextPlainAmp4email::ID,
            Tag\ScriptAmp3dGltf::ID,
            Tag\ScriptAmp3qPlayer::ID,
            Tag\ScriptAmpAccessLaterpay::ID,
            Tag\ScriptAmpAccessPoool::ID,
            Tag\ScriptAmpAccessScroll::ID,
            Tag\ScriptAmpAccess::ID,
            Tag\ScriptAmpAccordion::ID,
            Tag\ScriptAmpAccordion2::ID,
            Tag\ScriptAmpActionMacro::ID,
            Tag\ScriptAmpAdCustom::ID,
            Tag\ScriptAmpAdExit::ID,
            Tag\ScriptAmpAddthis::ID,
            Tag\ScriptAmpAnalytics::ID,
            Tag\ScriptAmpAnimation::ID,
            Tag\ScriptAmpAnim::ID,
            Tag\ScriptAmpApesterMedia::ID,
            Tag\ScriptAmpAppBanner::ID,
            Tag\ScriptAmpAudio::ID,
            Tag\ScriptAmpAutoAds::ID,
            Tag\ScriptAmpAutocomplete::ID,
            Tag\ScriptAmpBaseCarousel::ID,
            Tag\ScriptAmpBeopinion::ID,
            Tag\ScriptAmpBind::ID,
            Tag\ScriptAmpBodymovinAnimation::ID,
            Tag\ScriptAmpBridPlayer::ID,
            Tag\ScriptAmpBrightcove::ID,
            Tag\ScriptAmpBysideContent::ID,
            Tag\ScriptAmpCacheUrl::ID,
            Tag\ScriptAmpCallTracking::ID,
            Tag\ScriptAmpCarousel::ID,
            Tag\ScriptAmpConnatixPlayer::ID,
            Tag\ScriptAmpConsent::ID,
            Tag\ScriptAmpDailymotion::ID,
            Tag\ScriptAmpDateCountdown::ID,
            Tag\ScriptAmpDateDisplay::ID,
            Tag\ScriptAmpDatePicker::ID,
            Tag\ScriptAmpDelightPlayer::ID,
            Tag\ScriptAmpDynamicCssClasses::ID,
            Tag\ScriptAmpEmbedlyCard::ID,
            Tag\ScriptAmpExperiment::ID,
            Tag\ScriptAmpFacebookComments::ID,
            Tag\ScriptAmpFacebookLike::ID,
            Tag\ScriptAmpFacebookPage::ID,
            Tag\ScriptAmpFacebook::ID,
            Tag\ScriptAmpFitText::ID,
            Tag\ScriptAmpFitText2::ID,
            Tag\ScriptAmpFont::ID,
            Tag\ScriptAmpForm::ID,
            Tag\ScriptAmpFxCollection::ID,
            Tag\ScriptAmpFxFlyingCarpet::ID,
            Tag\ScriptAmpGeo::ID,
            Tag\ScriptAmpGfycat::ID,
            Tag\ScriptAmpGist::ID,
            Tag\ScriptAmpGoogleAssistantAssistjs::ID,
            Tag\ScriptAmpGoogleDocumentEmbed::ID,
            Tag\ScriptAmpGwdAnimation::ID,
            Tag\ScriptAmpHulu::ID,
            Tag\ScriptAmpIframely::ID,
            Tag\ScriptAmpIframe::ID,
            Tag\ScriptAmpImaVideo::ID,
            Tag\ScriptAmpImageLightbox::ID,
            Tag\ScriptAmpImageSlider::ID,
            Tag\ScriptAmpImgur::ID,
            Tag\ScriptAmpInlineGallery::ID,
            Tag\ScriptAmpInputmask::ID,
            Tag\ScriptAmpInstagram::ID,
            Tag\ScriptAmpInstagram2::ID,
            Tag\ScriptAmpInstallServiceworker::ID,
            Tag\ScriptAmpIzlesene::ID,
            Tag\ScriptAmpJwplayer::ID,
            Tag\ScriptAmpKalturaPlayer::ID,
            Tag\ScriptAmpLightboxGallery::ID,
            Tag\ScriptAmpLightbox::ID,
            Tag\ScriptAmpLightbox2::ID,
            Tag\ScriptAmpLinkRewriter::ID,
            Tag\ScriptAmpList::ID,
            Tag\ScriptAmpLiveList::ID,
            Tag\ScriptAmpMathml::ID,
            Tag\ScriptAmpMegaMenu::ID,
            Tag\ScriptAmpMegaphone::ID,
            Tag\ScriptAmpMinuteMediaPlayer::ID,
            Tag\ScriptAmpMowplayer::ID,
            Tag\ScriptAmpMraid::ID,
            Tag\ScriptAmpMustache::ID,
            Tag\ScriptAmpNestedMenu::ID,
            Tag\ScriptAmpNextPage::ID,
            Tag\ScriptAmpNexxtvPlayer::ID,
            Tag\ScriptAmpO2Player::ID,
            Tag\ScriptAmpOnetapGoogle::ID,
            Tag\ScriptAmpOoyalaPlayer::ID,
            Tag\ScriptAmpOrientationObserver::ID,
            Tag\ScriptAmpPanZoom::ID,
            Tag\ScriptAmpPinterest::ID,
            Tag\ScriptAmpPlaybuzz::ID,
            Tag\ScriptAmpPositionObserver::ID,
            Tag\ScriptAmpPowrPlayer::ID,
            Tag\ScriptAmpReachPlayer::ID,
            Tag\ScriptAmpRecaptchaInput::ID,
            Tag\ScriptAmpRedbullPlayer::ID,
            Tag\ScriptAmpReddit::ID,
            Tag\ScriptAmpRender::ID,
            Tag\ScriptAmpRiddleQuiz::ID,
            Tag\ScriptAmpScript::ID,
            Tag\ScriptAmpSelector::ID,
            Tag\ScriptAmpSelector2::ID,
            Tag\ScriptAmpSidebar::ID,
            Tag\ScriptAmpSkimlinks::ID,
            Tag\ScriptAmpSlides::ID,
            Tag\ScriptAmpSmartlinks::ID,
            Tag\ScriptAmpSocialShare::ID,
            Tag\ScriptAmpSocialShare2::ID,
            Tag\ScriptAmpSoundcloud::ID,
            Tag\ScriptAmpSpringboardPlayer::ID,
            Tag\ScriptAmpStickyAd::ID,
            Tag\ScriptAmpStory360::ID,
            Tag\ScriptAmpStoryAutoAds::ID,
            Tag\ScriptAmpStoryAutoAnalytics::ID,
            Tag\ScriptAmpStoryInteractive::ID,
            Tag\ScriptAmpStoryPanningMedia::ID,
            Tag\ScriptAmpStoryPlayer::ID,
            Tag\ScriptAmpStory::ID,
            Tag\ScriptAmpStreamGallery::ID,
            Tag\ScriptAmpSubscriptionsGoogle::ID,
            Tag\ScriptAmpSubscriptions::ID,
            Tag\ScriptAmpTimeago::ID,
            Tag\ScriptAmpTruncateText::ID,
            Tag\ScriptAmpTwitter::ID,
            Tag\ScriptAmpTwitter2::ID,
            Tag\ScriptAmpUserNotification::ID,
            Tag\ScriptAmpVideoDocking::ID,
            Tag\ScriptAmpVideoIframe::ID,
            Tag\ScriptAmpVideoIframe2::ID,
            Tag\ScriptAmpVideo::ID,
            Tag\ScriptAmpVideo2::ID,
            Tag\ScriptAmpVimeo::ID,
            Tag\ScriptAmpVimeo2::ID,
            Tag\ScriptAmpVine::ID,
            Tag\ScriptAmpViqeoPlayer::ID,
            Tag\ScriptAmpVk::ID,
            Tag\ScriptAmpWebPush::ID,
            Tag\ScriptAmpWistiaPlayer::ID,
            Tag\ScriptAmpYotpo::ID,
            Tag\ScriptAmpYoutube::ID,
            Tag\ScriptAmpYoutube2::ID,
            Tag\ScriptCustomElementAmpAccordionAmp4email::ID,
            Tag\ScriptCustomElementAmpAutocompleteAmp4email::ID,
            Tag\ScriptCustomElementAmpBindAmp4email::ID,
            Tag\ScriptCustomElementAmpCarouselAmp4email::ID,
            Tag\ScriptCustomElementAmpFitTextAmp4email::ID,
            Tag\ScriptCustomElementAmpFormAmp4email::ID,
            Tag\ScriptCustomElementAmpImageLightboxAmp4email::ID,
            Tag\ScriptCustomElementAmpLightboxAmp4ads::ID,
            Tag\ScriptCustomElementAmpLightboxAmp4email::ID,
            Tag\ScriptCustomElementAmpListAmp4email::ID,
            Tag\ScriptCustomElementAmpSelectorAmp4email::ID,
            Tag\ScriptCustomElementAmpSidebarAmp4email::ID,
            Tag\ScriptCustomElementAmpTimeagoAmp4email::ID,
            Tag\ScriptCustomTemplateAmpMustacheAmp4ads::ID,
            Tag\ScriptCustomTemplateAmpMustacheAmp4email::ID,
            Tag\SubscriptionsScriptCiphertext::ID,
        ],
        Extension::ACCORDION => Tag\AmpAccordion::ID,
        Element::SECTION => [
            Tag\AmpAccordionSection::ID,
            Tag\Section::ID,
            Tag\SectionAmp4email::ID,
            Tag\SubscriptionsSectionContentSwgAmpCacheNonce::ID,
        ],
        Extension::ACTION_MACRO => Tag\AmpActionMacro::ID,
        Extension::AD => [
            Tag\AmpAd::ID,
            Tag\AmpAdWithDataEnableRefreshAttribute::ID,
            Tag\AmpAdWithDataMultiSizeAttribute::ID,
            Tag\AmpAdWithTypeCustom::ID,
        ],
        Extension::AD_CUSTOM => Tag\AmpAdCustom::ID,
        Extension::AD_EXIT => Tag\AmpAdExit::ID,
        Extension::ADDTHIS => Tag\AmpAddthis::ID,
        Extension::ANALYTICS => Tag\AmpAnalytics::ID,
        Extension::ANIM => [
            Tag\AmpAnim::ID,
            Tag\AmpAnimAmp4email::ID,
        ],
        Extension::ANIMATION => Tag\AmpAnimation::ID,
        Extension::APESTER_MEDIA => Tag\AmpApesterMedia::ID,
        Extension::APP_BANNER => Tag\AmpAppBanner::ID,
        Element::BUTTON => [
            Tag\AmpAppBannerButtonOpenButton::ID,
            Tag\AmpListLoadMoreButtonLoadMoreClickable::ID,
            Tag\Button::ID,
            Tag\ButtonAmpNestedMenu::ID,
        ],
        Extension::AUDIO => [
            Tag\AmpAudio::ID,
            Tag\AmpAudioA4a::ID,
            Tag\AmpStoryAmpAudio::ID,
        ],
        Element::SOURCE => [
            Tag\AmpAudioSource::ID,
            Tag\AmpImaVideoSource::ID,
            Tag\AmpVideoSource::ID,
            Tag\AudioSource::ID,
            Tag\PictureSource::ID,
            Tag\VideoSource::ID,
        ],
        Element::TRACK => [
            Tag\AmpAudioTrack::ID,
            Tag\AmpAudioTrackKindSubtitles::ID,
            Tag\AmpImaVideoTrack::ID,
            Tag\AmpImaVideoTrackKindSubtitles::ID,
            Tag\AmpVideoTrack::ID,
            Tag\AmpVideoTrackKindSubtitles::ID,
            Tag\AudioTrack::ID,
            Tag\AudioTrackKindSubtitles::ID,
            Tag\VideoTrack::ID,
            Tag\VideoTrackKindSubtitles::ID,
        ],
        Extension::AUTO_ADS => Tag\AmpAutoAds::ID,
        Extension::AUTOCOMPLETE => [
            Tag\AmpAutocomplete::ID,
            Tag\AmpAutocompleteAmp4email::ID,
        ],
        Element::INPUT => [
            Tag\AmpAutocompleteInput::ID,
            Tag\Input::ID,
            Tag\InputMaskDateDdMmYyyy::ID,
            Tag\InputMaskDateMmDdYyyy::ID,
            Tag\InputMaskDateMmYy::ID,
            Tag\InputMaskDateYyyyMmDd::ID,
            Tag\InputMaskPaymentCard::ID,
            Tag\InputMaskCustomMask::ID,
            Tag\InputTypeFile::ID,
            Tag\InputTypePassword::ID,
        ],
        Extension::BASE_CAROUSEL => [
            Tag\AmpBaseCarousel::ID,
            Tag\AmpBaseCarouselLightbox::ID,
        ],
        Extension::BEOPINION => Tag\AmpBeopinion::ID,
        Extension::BIND_MACRO => Tag\AmpBindMacro::ID,
        Extension::BODYMOVIN_ANIMATION => Tag\AmpBodymovinAnimation::ID,
        Extension::BRID_PLAYER => Tag\AmpBridPlayer::ID,
        Extension::BRIGHTCOVE => Tag\AmpBrightcove::ID,
        Extension::BYSIDE_CONTENT => Tag\AmpBysideContent::ID,
        Extension::CALL_TRACKING => Tag\AmpCallTracking::ID,
        Extension::CAROUSEL => [
            Tag\AmpCarousel::ID,
            Tag\AmpCarouselLightbox::ID,
        ],
        Extension::CONNATIX_PLAYER => Tag\AmpConnatixPlayer::ID,
        Extension::CONSENT => [
            Tag\AmpConsent::ID,
            Tag\AmpConsentType::ID,
        ],
        Extension::DAILYMOTION => Tag\AmpDailymotion::ID,
        Extension::DATE_COUNTDOWN => Tag\AmpDateCountdown::ID,
        Extension::DATE_DISPLAY => Tag\AmpDateDisplay::ID,
        Element::TEMPLATE => [
            Tag\AmpDatePickerTemplateDateTemplate::ID,
            Tag\AmpDatePickerTemplateInfoTemplate::ID,
            Tag\AmpStoryAutoAdsTemplate::ID,
            Tag\Template::ID,
            Tag\TemplateAmp4email::ID,
        ],
        Extension::DATE_PICKER => [
            Tag\AmpDatePickerTypeRangeModeOverlay::ID,
            Tag\AmpDatePickerTypeRangeModeStatic::ID,
            Tag\AmpDatePickerTypeSingleModeOverlay::ID,
            Tag\AmpDatePickerTypeSingleModeStatic::ID,
        ],
        Extension::DELIGHT_PLAYER => Tag\AmpDelightPlayer::ID,
        Extension::EMBED => [
            Tag\AmpEmbed::ID,
            Tag\AmpEmbedWithDataMultiSizeAttribute::ID,
        ],
        Extension::EMBEDLY_CARD => Tag\AmpEmbedlyCard::ID,
        Extension::EMBEDLY_KEY => Tag\AmpEmbedlyKey::ID,
        Extension::EXPERIMENT => Tag\AmpExperiment::ID,
        Extension::FACEBOOK => Tag\AmpFacebook::ID,
        Extension::FACEBOOK_COMMENTS => Tag\AmpFacebookComments::ID,
        Extension::FACEBOOK_LIKE => Tag\AmpFacebookLike::ID,
        Extension::FACEBOOK_PAGE => Tag\AmpFacebookPage::ID,
        Extension::FIT_TEXT => Tag\AmpFitText::ID,
        Extension::FONT => Tag\AmpFont::ID,
        Extension::FX_FLYING_CARPET => Tag\AmpFxFlyingCarpet::ID,
        Extension::GEO => Tag\AmpGeo::ID,
        Extension::GFYCAT => Tag\AmpGfycat::ID,
        Extension::GIST => Tag\AmpGist::ID,
        Extension::GOOGLE_ASSISTANT_ASSISTJS_CONFIG => Tag\AmpGoogleAssistantAssistjsConfig::ID,
        Extension::GOOGLE_ASSISTANT_INLINE_SUGGESTION_BAR => Tag\AmpGoogleAssistantInlineSuggestionBar::ID,
        Extension::GOOGLE_ASSISTANT_VOICE_BAR => Tag\AmpGoogleAssistantVoiceBar::ID,
        Extension::GOOGLE_ASSISTANT_VOICE_BUTTON => Tag\AmpGoogleAssistantVoiceButton::ID,
        Extension::GOOGLE_DOCUMENT_EMBED => Tag\AmpGoogleDocumentEmbed::ID,
        Extension::GWD_ANIMATION => Tag\AmpGwdAnimation::ID,
        Extension::HULU => Tag\AmpHulu::ID,
        Extension::IFRAME => Tag\AmpIframe::ID,
        Extension::IFRAMELY => Tag\AmpIframely::ID,
        Extension::IMA_VIDEO => Tag\AmpImaVideo::ID,
        Extension::IMAGE_LIGHTBOX => Tag\AmpImageLightbox::ID,
        Extension::IMAGE_SLIDER => [
            Tag\AmpImageSlider::ID,
            Tag\AmpImageSliderTransformed::ID,
        ],
        Element::DIV => [
            Tag\AmpImageSliderDivFirst::ID,
            Tag\AmpImageSliderDivSecond::ID,
            Tag\AmpListDivFetchError::ID,
            Tag\Div::ID,
            Tag\DivAmpNestedMenu::ID,
            Tag\FormDivSubmitError::ID,
            Tag\FormDivSubmitErrorTemplate::ID,
            Tag\FormDivSubmitSuccess::ID,
            Tag\FormDivSubmitSuccessTemplate::ID,
            Tag\FormDivSubmitting::ID,
            Tag\FormDivSubmittingTemplate::ID,
            Tag\FormDivVerifyError::ID,
            Tag\FormDivVerifyErrorTemplate::ID,
        ],
        Extension::IMG => [
            Tag\AmpImg::ID,
            Tag\AmpImgAmp4email::ID,
            Tag\AmpImgTransformed::ID,
        ],
        Element::IMG => [
            Tag\AmpImgImgTransformed::ID,
            Tag\AmpImgImgPlaceholderTransformed::ID,
            Tag\AmpStoryPlayerImg::ID,
            Tag\ImgIAmphtmlIntrinsicSizer::ID,
            Tag\ImgIAmphtmlIntrinsicSizerAmpStoryPlayer::ID,
            Tag\NoscriptImg::ID,
        ],
        Extension::IMGUR => Tag\AmpImgur::ID,
        Extension::INLINE_GALLERY => Tag\AmpInlineGallery::ID,
        Extension::INLINE_GALLERY_PAGINATION => [
            Tag\AmpInlineGalleryPagination::ID,
            Tag\AmpInlineGalleryPaginationInset::ID,
        ],
        Extension::INLINE_GALLERY_THUMBNAILS => Tag\AmpInlineGalleryThumbnails::ID,
        Extension::INSTAGRAM => Tag\AmpInstagram::ID,
        Extension::INSTALL_SERVICEWORKER => Tag\AmpInstallServiceworker::ID,
        Extension::IZLESENE => Tag\AmpIzlesene::ID,
        Extension::JWPLAYER => Tag\AmpJwplayer::ID,
        Extension::KALTURA_PLAYER => Tag\AmpKalturaPlayer::ID,
        Extension::LAYOUT => Tag\AmpLayout::ID,
        Extension::LIGHTBOX => [
            Tag\AmpLightbox::ID,
            Tag\AmpLightboxAmp4ads::ID,
        ],
        Extension::LINK_REWRITER => Tag\AmpLinkRewriter::ID,
        Extension::LIST_ => [
            Tag\AmpList::ID,
            Tag\AmpListAmp4email::ID,
        ],
        Extension::LIST_LOAD_MORE => Tag\AmpListLoadMore::ID,
        Extension::LIVE_LIST => Tag\AmpLiveList::ID,
        Extension::MATHML => Tag\AmpMathml::ID,
        Extension::MEGA_MENU => Tag\AmpMegaMenu::ID,
        Extension::MEGAPHONE => [
            Tag\AmpMegaphoneDataEpisode::ID,
            Tag\AmpMegaphoneDataPlaylist::ID,
        ],
        Extension::MINUTE_MEDIA_PLAYER => Tag\AmpMinuteMediaPlayer::ID,
        Extension::MOWPLAYER => Tag\AmpMowplayer::ID,
        Extension::NESTED_MENU => Tag\AmpNestedMenu::ID,
        Extension::NEXT_PAGE => [
            Tag\AmpNextPageWithInlineConfig::ID,
            Tag\AmpNextPageWithSrcAttribute::ID,
            Tag\AmpNextPageTypeAdsense::ID,
        ],
        Extension::NEXXTV_PLAYER => Tag\AmpNexxtvPlayer::ID,
        Extension::O2_PLAYER => Tag\AmpO2Player::ID,
        Extension::ONETAP_GOOGLE => Tag\AmpOnetapGoogle::ID,
        Extension::OOYALA_PLAYER => Tag\AmpOoyalaPlayer::ID,
        Extension::ORIENTATION_OBSERVER => Tag\AmpOrientationObserver::ID,
        Extension::PAN_ZOOM => Tag\AmpPanZoom::ID,
        Extension::PINTEREST => Tag\AmpPinterest::ID,
        Extension::PIXEL => Tag\AmpPixel::ID,
        Extension::PLAYBUZZ => Tag\AmpPlaybuzz::ID,
        Extension::POSITION_OBSERVER => Tag\AmpPositionObserver::ID,
        Extension::POWR_PLAYER => Tag\AmpPowrPlayer::ID,
        Extension::REACH_PLAYER => Tag\AmpReachPlayer::ID,
        Extension::RECAPTCHA_INPUT => Tag\AmpRecaptchaInput::ID,
        Extension::REDBULL_PLAYER => Tag\AmpRedbullPlayer::ID,
        Extension::REDDIT => Tag\AmpReddit::ID,
        Extension::RENDER => Tag\AmpRender::ID,
        Extension::RIDDLE_QUIZ => Tag\AmpRiddleQuiz::ID,
        Extension::SCRIPT => Tag\AmpScript::ID,
        Extension::SELECTOR => Tag\AmpSelector::ID,
        Extension::SIDEBAR => [
            Tag\AmpSidebar::ID,
            Tag\AmpSidebarAmp4email::ID,
            Tag\AmpStoryAmpSidebar::ID,
        ],
        Element::NAV => [
            Tag\AmpSidebarNav::ID,
            Tag\Nav::ID,
        ],
        Extension::SKIMLINKS => Tag\AmpSkimlinks::ID,
        Extension::SMARTLINKS => Tag\AmpSmartlinks::ID,
        Extension::SOCIAL_SHARE => Tag\AmpSocialShare::ID,
        Extension::SOUNDCLOUD => Tag\AmpSoundcloud::ID,
        Extension::SPRINGBOARD_PLAYER => Tag\AmpSpringboardPlayer::ID,
        Extension::STATE => [
            Tag\AmpState::ID,
            Tag\AmpStateAmp4email::ID,
        ],
        Extension::STICKY_AD => Tag\AmpStickyAd::ID,
        Extension::STORY => Tag\AmpStory::ID,
        Extension::STORY_360 => Tag\AmpStory360::ID,
        Extension::STORY_ANIMATION => Tag\AmpStoryAnimation::ID,
        Extension::STORY_AUTO_ADS => Tag\AmpStoryAutoAds::ID,
        Extension::STORY_AUTO_ANALYTICS => Tag\AmpStoryAutoAnalytics::ID,
        Extension::STORY_BOOKEND => Tag\AmpStoryBookend::ID,
        Extension::STORY_CONSENT => Tag\AmpStoryConsent::ID,
        Extension::STORY_CTA_LAYER => Tag\AmpStoryCtaLayer::ID,
        Extension::STORY_GRID_LAYER => Tag\AmpStoryGridLayer::ID,
        Extension::STORY_INTERACTIVE_BINARY_POLL => Tag\AmpStoryInteractiveBinaryPoll::ID,
        Extension::STORY_INTERACTIVE_POLL => Tag\AmpStoryInteractivePoll::ID,
        Extension::STORY_INTERACTIVE_QUIZ => Tag\AmpStoryInteractiveQuiz::ID,
        Extension::STORY_INTERACTIVE_RESULTS => Tag\AmpStoryInteractiveResults::ID,
        Extension::STORY_PAGE => Tag\AmpStoryPage::ID,
        Extension::STORY_PAGE_ATTACHMENT => [
            Tag\AmpStoryPageAttachment::ID,
            Tag\AmpStoryPageAttachmentHref::ID,
        ],
        Extension::STORY_PAGE_OUTLINK => Tag\AmpStoryPageOutlink::ID,
        Extension::STORY_PANNING_MEDIA => Tag\AmpStoryPanningMedia::ID,
        Extension::STORY_PLAYER => Tag\AmpStoryPlayer::ID,
        Extension::STORY_SOCIAL_SHARE => Tag\AmpStorySocialShare::ID,
        Extension::VIDEO => [
            Tag\AmpStoryAmpStoryPageAttachmentAmpVideo::ID,
            Tag\AmpStoryAmpVideo::ID,
            Tag\AmpVideo::ID,
        ],
        Extension::STREAM_GALLERY => Tag\AmpStreamGallery::ID,
        Extension::TIMEAGO => Tag\AmpTimeago::ID,
        Extension::TRUNCATE_TEXT => Tag\AmpTruncateText::ID,
        Extension::TWITTER => Tag\AmpTwitter::ID,
        Extension::USER_NOTIFICATION => Tag\AmpUserNotification::ID,
        Extension::VIDEO_IFRAME => [
            Tag\AmpVideoIframe::ID,
            Tag\AmpVideoIframeTransformed::ID,
        ],
        Extension::VIMEO => Tag\AmpVimeo::ID,
        Extension::VINE => Tag\AmpVine::ID,
        Extension::VIQEO_PLAYER => Tag\AmpViqeoPlayer::ID,
        Extension::VK => Tag\AmpVk::ID,
        Extension::WEB_PUSH => Tag\AmpWebPush::ID,
        Extension::WEB_PUSH_WIDGET => Tag\AmpWebPushWidget::ID,
        Extension::WISTIA_PLAYER => Tag\AmpWistiaPlayer::ID,
        Extension::YOTPO => Tag\AmpYotpo::ID,
        Extension::YOUTUBE => Tag\AmpYoutube::ID,
        Element::ARTICLE => Tag\Article::ID,
        Element::ASIDE => Tag\Aside::ID,
        Element::AUDIO => Tag\Audio::ID,
        Element::B => Tag\B::ID,
        Element::BASE => Tag\Base::ID,
        Element::BDI => Tag\Bdi::ID,
        Element::BDO => Tag\Bdo::ID,
        Element::BIG => Tag\Big::ID,
        Element::BLOCKQUOTE => Tag\Blockquote::ID,
        Element::BODY => Tag\Body::ID,
        Element::BR => Tag\Br::ID,
        Element::CANVAS => Tag\Canvas::ID,
        Element::CAPTION => Tag\Caption::ID,
        Element::CENTER => Tag\Center::ID,
        Element::CIRCLE => Tag\Circle::ID,
        Element::CITE => Tag\Cite::ID,
        Element::CLIPPATH => Tag\Clippath::ID,
        Element::CODE => Tag\Code::ID,
        Element::COL => Tag\Col::ID,
        Element::COLGROUP => Tag\Colgroup::ID,
        Element::DATA => Tag\Data::ID,
        Element::DATALIST => Tag\Datalist::ID,
        Element::DD => Tag\Dd::ID,
        Element::DEFS => Tag\Defs::ID,
        Element::DEL => Tag\Del::ID,
        Element::DESC => Tag\Desc::ID,
        Element::DETAILS => Tag\Details::ID,
        Element::DFN => Tag\Dfn::ID,
        Element::DIR => Tag\Dir::ID,
        Element::DL => Tag\Dl::ID,
        Element::DT => Tag\Dt::ID,
        Element::ELLIPSE => Tag\Ellipse::ID,
        Element::EM => Tag\Em::ID,
        Element::FEBLEND => Tag\Feblend::ID,
        Element::FECOLORMATRIX => Tag\Fecolormatrix::ID,
        Element::FECOMPONENTTRANSFER => Tag\Fecomponenttransfer::ID,
        Element::FECOMPOSITE => Tag\Fecomposite::ID,
        Element::FECONVOLVEMATRIX => Tag\Feconvolvematrix::ID,
        Element::FEDIFFUSELIGHTING => Tag\Fediffuselighting::ID,
        Element::FEDISPLACEMENTMAP => Tag\Fedisplacementmap::ID,
        Element::FEDISTANTLIGHT => Tag\Fedistantlight::ID,
        Element::FEDROPSHADOW => Tag\Fedropshadow::ID,
        Element::FEFLOOD => Tag\Feflood::ID,
        Element::FEFUNCA => Tag\Fefunca::ID,
        Element::FEFUNCB => Tag\Fefuncb::ID,
        Element::FEFUNCG => Tag\Fefuncg::ID,
        Element::FEFUNCR => Tag\Fefuncr::ID,
        Element::FEGAUSSIANBLUR => Tag\Fegaussianblur::ID,
        Element::FEMERGE => Tag\Femerge::ID,
        Element::FEMERGENODE => Tag\Femergenode::ID,
        Element::FEMORPHOLOGY => Tag\Femorphology::ID,
        Element::FEOFFSET => Tag\Feoffset::ID,
        Element::FEPOINTLIGHT => Tag\Fepointlight::ID,
        Element::FESPECULARLIGHTING => Tag\Fespecularlighting::ID,
        Element::FESPOTLIGHT => Tag\Fespotlight::ID,
        Element::FETILE => Tag\Fetile::ID,
        Element::FETURBULENCE => Tag\Feturbulence::ID,
        Element::FIELDSET => Tag\Fieldset::ID,
        Element::FIGCAPTION => Tag\Figcaption::ID,
        Element::FIGURE => Tag\Figure::ID,
        Element::FILTER => Tag\Filter::ID,
        Element::FOOTER => Tag\Footer::ID,
        Element::FORM => [
            Tag\FormMethodGet::ID,
            Tag\FormMethodGetAmp4email::ID,
            Tag\FormMethodPost::ID,
            Tag\FormMethodPostAmp4email::ID,
        ],
        Element::G => Tag\G::ID,
        Element::GLYPH => Tag\Glyph::ID,
        Element::GLYPHREF => Tag\Glyphref::ID,
        Element::H1 => Tag\H1::ID,
        Element::H2 => [
            Tag\H2::ID,
            Tag\H2AmpNestedMenu::ID,
        ],
        Element::H3 => [
            Tag\H3::ID,
            Tag\H3AmpNestedMenu::ID,
        ],
        Element::H4 => [
            Tag\H4::ID,
            Tag\H4AmpNestedMenu::ID,
        ],
        Element::H5 => [
            Tag\H5::ID,
            Tag\H5AmpNestedMenu::ID,
        ],
        Element::H6 => [
            Tag\H6::ID,
            Tag\H6AmpNestedMenu::ID,
        ],
        Element::HEAD => Tag\Head::ID,
        Element::STYLE => [
            Tag\HeadStyleAmpBoilerplate::ID,
            Tag\HeadStyleAmpBoilerplateTransformed::ID,
            Tag\HeadStyleAmp4adsBoilerplate::ID,
            Tag\HeadStyleAmp4emailBoilerplate::ID,
            Tag\NoscriptStyleAmpBoilerplate::ID,
            Tag\NoscriptStyleAmpBoilerplateTransformed::ID,
            Tag\StyleAmpCustom::ID,
            Tag\StyleAmpCustomAmp4ads::ID,
            Tag\StyleAmpCustomAmp4email::ID,
            Tag\StyleAmpCustomCssStrict::ID,
            Tag\StyleAmpCustomLengthCheck::ID,
            Tag\StyleAmpKeyframes::ID,
            Tag\StyleAmpRuntimeTransformed::ID,
        ],
        Element::HEADER => Tag\Header::ID,
        Element::HGROUP => Tag\Hgroup::ID,
        Element::HKERN => Tag\Hkern::ID,
        Element::HR => Tag\Hr::ID,
        Element::HTML => [
            Tag\Html::ID,
            Tag\HtmlTransformed::ID,
        ],
        Element::_DOCTYPE => [
            Tag\HtmlDoctype::ID,
            Tag\HtmlDoctypeAmp4ads::ID,
        ],
        Element::I => Tag\I::ID,
        Internal::SIZER => [
            Tag\IAmphtmlSizerIntrinsic::ID,
            Tag\IAmphtmlSizerResponsive::ID,
        ],
        Element::IFRAME => Tag\Iframe::ID,
        Element::IMAGE => Tag\Image::ID,
        Element::INS => Tag\Ins::ID,
        Element::KBD => Tag\Kbd::ID,
        Element::LABEL => Tag\Label::ID,
        Element::LEGEND => Tag\Legend::ID,
        Element::LI => Tag\Li::ID,
        Element::LINE => Tag\Line::ID,
        Element::LINEARGRADIENT => Tag\Lineargradient::ID,
        Element::STOP => [
            Tag\LineargradientStop::ID,
            Tag\RadialgradientStop::ID,
        ],
        Element::LINK => [
            Tag\LinkItemprop::ID,
            Tag\LinkItempropSameas::ID,
            Tag\LinkProperty::ID,
            Tag\LinkRel::ID,
            Tag\LinkRelCanonical::ID,
            Tag\LinkRelManifest::ID,
            Tag\LinkRelModulepreload::ID,
            Tag\LinkRelPreload::ID,
            Tag\LinkRelStylesheetForFonts::ID,
        ],
        Element::LISTING => Tag\Listing::ID,
        Element::MAIN => Tag\Main::ID,
        Element::MARK => Tag\Mark::ID,
        Element::MARKER => Tag\Marker::ID,
        Element::MASK => Tag\Mask::ID,
        Element::META => [
            Tag\MetaCharsetUtf8::ID,
            Tag\MetaHttpEquivContentLanguage::ID,
            Tag\MetaHttpEquivContentScriptType::ID,
            Tag\MetaHttpEquivContentStyleType::ID,
            Tag\MetaHttpEquivContentType::ID,
            Tag\MetaHttpEquivImagetoolbar::ID,
            Tag\MetaHttpEquivOriginTrial::ID,
            Tag\MetaHttpEquivPicsLabel::ID,
            Tag\MetaHttpEquivResourceType::ID,
            Tag\MetaHttpEquivXDnsPrefetchControl::ID,
            Tag\MetaHttpEquivXUaCompatible::ID,
            Tag\MetaNameAmp3pIframeSrc::ID,
            Tag\MetaNameAmpAdDoubleclickSra::ID,
            Tag\MetaNameAmpAdEnableRefresh::ID,
            Tag\MetaNameAmpConsentBlocking::ID,
            Tag\MetaNameAmpCtaLandingPageType::ID,
            Tag\MetaNameAmpCtaType::ID,
            Tag\MetaNameAmpCtaUrl::ID,
            Tag\MetaNameAmpExperimentToken::ID,
            Tag\MetaNameAmpExperimentsOptIn::ID,
            Tag\MetaNameAmpGoogleClientidIdApi::ID,
            Tag\MetaNameAmpLinkVariableAllowedOrigin::ID,
            Tag\MetaNameAmpListLoadMore::ID,
            Tag\MetaNameAmpRecaptchaInput::ID,
            Tag\MetaNameAmpScriptSrc::ID,
            Tag\MetaNameAmpStoryGeneratorName::ID,
            Tag\MetaNameAmpStoryGeneratorVersion::ID,
            Tag\MetaNameAmpToAmpNavigation::ID,
            Tag\MetaNameAmp4adsId::ID,
            Tag\MetaNameAmp4adsVars::ID,
            Tag\MetaNameAndContent::ID,
            Tag\MetaNameAppleItunesApp::ID,
            Tag\MetaNameViewport::ID,
        ],
        Element::METADATA => Tag\Metadata::ID,
        Element::METER => Tag\Meter::ID,
        Element::MULTICOL => Tag\Multicol::ID,
        Element::NEXTID => Tag\Nextid::ID,
        Element::NOBR => Tag\Nobr::ID,
        Element::NOSCRIPT => [
            Tag\Noscript::ID,
            Tag\NoscriptEnclosureForBoilerplate::ID,
            Tag\NoscriptEnclosureForBoilerplateTransformed::ID,
        ],
        Element::O_P => Tag\OP::ID,
        Element::OL => Tag\Ol::ID,
        Element::OPTGROUP => Tag\Optgroup::ID,
        Element::OPTION => Tag\Option::ID,
        Element::OUTPUT => Tag\Output::ID,
        Element::P => Tag\P::ID,
        Element::PATH => Tag\Path::ID,
        Element::PATTERN => Tag\Pattern::ID,
        Element::PICTURE => Tag\Picture::ID,
        Element::POLYGON => Tag\Polygon::ID,
        Element::POLYLINE => Tag\Polyline::ID,
        Element::PRE => Tag\Pre::ID,
        Element::PROGRESS => Tag\Progress::ID,
        Element::Q => Tag\Q::ID,
        Element::RADIALGRADIENT => Tag\Radialgradient::ID,
        Element::RB => Tag\Rb::ID,
        Element::RECT => Tag\Rect::ID,
        Element::RP => Tag\Rp::ID,
        Element::RT => Tag\Rt::ID,
        Element::RTC => Tag\Rtc::ID,
        Element::RUBY => Tag\Ruby::ID,
        Element::S => Tag\S::ID,
        Element::SAMP => Tag\Samp::ID,
        Element::SELECT => Tag\Select::ID,
        Element::SLOT => Tag\Slot::ID,
        Element::SMALL => Tag\Small::ID,
        Element::SOLIDCOLOR => Tag\Solidcolor::ID,
        Element::SPACER => Tag\Spacer::ID,
        Element::SPAN => [
            Tag\Span::ID,
            Tag\SpanAmpNestedMenu::ID,
            Tag\SpanSwgAmpCacheNonce::ID,
        ],
        Element::STRIKE => Tag\Strike::ID,
        Element::STRONG => Tag\Strong::ID,
        Element::SUB => Tag\Sub::ID,
        Element::SUMMARY => Tag\Summary::ID,
        Element::SUP => Tag\Sup::ID,
        Element::SVG => Tag\Svg::ID,
        Element::TITLE => [
            Tag\SvgTitle::ID,
            Tag\Title::ID,
            Tag\TitleAmp4email::ID,
        ],
        Element::SWITCH_ => Tag\Switch_::ID,
        Element::SYMBOL => Tag\Symbol::ID,
        Element::TABLE => Tag\Table::ID,
        Element::TBODY => Tag\Tbody::ID,
        Element::TD => Tag\Td::ID,
        Element::TEXT => Tag\Text::ID,
        Element::TEXTAREA => Tag\Textarea::ID,
        Element::TEXTPATH => Tag\Textpath::ID,
        Element::TFOOT => Tag\Tfoot::ID,
        Element::TH => Tag\Th::ID,
        Element::THEAD => Tag\Thead::ID,
        Element::TIME => Tag\Time::ID,
        Element::TR => Tag\Tr::ID,
        Element::TREF => Tag\Tref::ID,
        Element::TSPAN => Tag\Tspan::ID,
        Element::TT => Tag\Tt::ID,
        Element::U => Tag\U::ID,
        Element::UL => Tag\Ul::ID,
        Element::USE_ => Tag\Use_::ID,
        Element::VAR_ => Tag\Var_::ID,
        Element::VIDEO => Tag\Video::ID,
        Element::VIEW => Tag\View::ID,
        Element::VKERN => Tag\Vkern::ID,
        Element::WBR => Tag\Wbr::ID,
    ];

    /**
     * Mapping of spec name to tag ID.
     *
     * This is used to optimize querying by spec name.
     *
     * @var array<string>
     */
    const BY_SPEC_NAME = [
        Tag\AAmp4email::ID => Tag\AAmp4email::ID,
        Tag\AmpAccessExtensionJsonScript::ID => Tag\AmpAccessExtensionJsonScript::ID,
        Tag\AmpAccordionSection::ID => Tag\AmpAccordionSection::ID,
        Tag\AmpAdExitConfigurationJson::ID => Tag\AmpAdExitConfigurationJson::ID,
        Tag\AmpAdExtensionScript::ID => Tag\AmpAdExtensionScript::ID,
        Tag\AmpAdWithDataEnableRefreshAttribute::ID => Tag\AmpAdWithDataEnableRefreshAttribute::ID,
        Tag\AmpAdWithDataMultiSizeAttribute::ID => Tag\AmpAdWithDataMultiSizeAttribute::ID,
        Tag\AmpAdWithTypeCustom::ID => Tag\AmpAdWithTypeCustom::ID,
        Tag\AmpAnalyticsExtensionJsonScript::ID => Tag\AmpAnalyticsExtensionJsonScript::ID,
        Tag\AmpAnimAmp4email::ID => Tag\AmpAnimAmp4email::ID,
        Tag\AmpAnimationExtensionJsonScript::ID => Tag\AmpAnimationExtensionJsonScript::ID,
        Tag\AmpAnimExtensionScriptAmp4email::ID => Tag\AmpAnimExtensionScriptAmp4email::ID,
        Tag\AmpAppBannerButtonOpenButton::ID => Tag\AmpAppBannerButtonOpenButton::ID,
        Tag\AmpAudioA4a::ID => Tag\AmpAudioA4a::ID,
        Tag\AmpAudioSource::ID => Tag\AmpAudioSource::ID,
        Tag\AmpAudioTrack::ID => Tag\AmpAudioTrack::ID,
        Tag\AmpAudioTrackKindSubtitles::ID => Tag\AmpAudioTrackKindSubtitles::ID,
        Tag\AmpAutocomplete::ID => Tag\AmpAutocomplete::ID,
        Tag\AmpAutocompleteAmp4email::ID => Tag\AmpAutocompleteAmp4email::ID,
        Tag\AmpAutocompleteInput::ID => Tag\AmpAutocompleteInput::ID,
        Tag\AmpAutocompleteJson::ID => Tag\AmpAutocompleteJson::ID,
        Tag\AmpBaseCarouselLightboxChild::ID => Tag\AmpBaseCarouselLightboxChild::ID,
        Tag\AmpBaseCarouselLightboxLightboxExclude::ID => Tag\AmpBaseCarouselLightboxLightboxExclude::ID,
        Tag\AmpBaseCarouselLightbox::ID => Tag\AmpBaseCarouselLightbox::ID,
        Tag\AmpBindExtensionJsonScript::ID => Tag\AmpBindExtensionJsonScript::ID,
        Tag\AmpCarousel::ID => Tag\AmpCarousel::ID,
        Tag\AmpCarouselLightbox::ID => Tag\AmpCarouselLightbox::ID,
        Tag\AmpCarouselLightboxChild::ID => Tag\AmpCarouselLightboxChild::ID,
        Tag\AmpCarouselLightboxLightboxExclude::ID => Tag\AmpCarouselLightboxLightboxExclude::ID,
        Tag\AmpConsentExtensionJsonScript::ID => Tag\AmpConsentExtensionJsonScript::ID,
        Tag\AmpConsentType::ID => Tag\AmpConsentType::ID,
        Tag\AmpDatePickerTemplateDateTemplate::ID => Tag\AmpDatePickerTemplateDateTemplate::ID,
        Tag\AmpDatePickerTemplateInfoTemplate::ID => Tag\AmpDatePickerTemplateInfoTemplate::ID,
        Tag\AmpDatePickerTypeRangeModeOverlay::ID => Tag\AmpDatePickerTypeRangeModeOverlay::ID,
        Tag\AmpDatePickerTypeRangeModeStatic::ID => Tag\AmpDatePickerTypeRangeModeStatic::ID,
        Tag\AmpDatePickerTypeSingleModeOverlay::ID => Tag\AmpDatePickerTypeSingleModeOverlay::ID,
        Tag\AmpDatePickerTypeSingleModeStatic::ID => Tag\AmpDatePickerTypeSingleModeStatic::ID,
        Tag\AmpEmbedWithDataMultiSizeAttribute::ID => Tag\AmpEmbedWithDataMultiSizeAttribute::ID,
        Tag\AmpExperimentExtensionJsonScript::ID => Tag\AmpExperimentExtensionJsonScript::ID,
        Tag\AmpExperimentStoryExtensionJsonScript::ID => Tag\AmpExperimentStoryExtensionJsonScript::ID,
        Tag\AmpGeoExtensionJsonScript::ID => Tag\AmpGeoExtensionJsonScript::ID,
        Tag\AmpImaVideoScriptTypeApplicationJson::ID => Tag\AmpImaVideoScriptTypeApplicationJson::ID,
        Tag\AmpImaVideoSource::ID => Tag\AmpImaVideoSource::ID,
        Tag\AmpImaVideoTrack::ID => Tag\AmpImaVideoTrack::ID,
        Tag\AmpImaVideoTrackKindSubtitles::ID => Tag\AmpImaVideoTrackKindSubtitles::ID,
        Tag\AmpImageSliderTransformed::ID => Tag\AmpImageSliderTransformed::ID,
        Tag\AmpImageSliderDivFirst::ID => Tag\AmpImageSliderDivFirst::ID,
        Tag\AmpImageSliderDivSecond::ID => Tag\AmpImageSliderDivSecond::ID,
        Tag\AmpImgAmp4email::ID => Tag\AmpImgAmp4email::ID,
        Tag\AmpImgTransformed::ID => Tag\AmpImgTransformed::ID,
        Tag\AmpImgImgTransformed::ID => Tag\AmpImgImgTransformed::ID,
        Tag\AmpImgImgPlaceholderTransformed::ID => Tag\AmpImgImgPlaceholderTransformed::ID,
        Tag\AmpInlineGalleryPagination::ID => Tag\AmpInlineGalleryPagination::ID,
        Tag\AmpInlineGalleryPaginationInset::ID => Tag\AmpInlineGalleryPaginationInset::ID,
        Tag\AmpLightboxAmp4ads::ID => Tag\AmpLightboxAmp4ads::ID,
        Tag\AmpLinkRewriterExtensionJsonScript::ID => Tag\AmpLinkRewriterExtensionJsonScript::ID,
        Tag\AmpListAmp4email::ID => Tag\AmpListAmp4email::ID,
        Tag\AmpListLoadMoreButtonLoadMoreClickable::ID => Tag\AmpListLoadMoreButtonLoadMoreClickable::ID,
        Tag\AmpListDivFetchError::ID => Tag\AmpListDivFetchError::ID,
        Tag\AmpLiveListItems::ID => Tag\AmpLiveListItems::ID,
        Tag\AmpLiveListItemsItem::ID => Tag\AmpLiveListItemsItem::ID,
        Tag\AmpLiveListPagination::ID => Tag\AmpLiveListPagination::ID,
        Tag\AmpLiveListUpdate::ID => Tag\AmpLiveListUpdate::ID,
        Tag\AmpMegaMenuAmpList::ID => Tag\AmpMegaMenuAmpList::ID,
        Tag\AmpMegaMenuAmpListTemplate::ID => Tag\AmpMegaMenuAmpListTemplate::ID,
        Tag\AmpMegaMenuNav::ID => Tag\AmpMegaMenuNav::ID,
        Tag\AmpMegaMenuItemContent::ID => Tag\AmpMegaMenuItemContent::ID,
        Tag\AmpMegaMenuItemHeading::ID => Tag\AmpMegaMenuItemHeading::ID,
        Tag\AmpMegaMenuNavUlOl::ID => Tag\AmpMegaMenuNavUlOl::ID,
        Tag\AmpMegaMenuNavUlOlLi::ID => Tag\AmpMegaMenuNavUlOlLi::ID,
        Tag\AmpMegaphoneDataEpisode::ID => Tag\AmpMegaphoneDataEpisode::ID,
        Tag\AmpMegaphoneDataPlaylist::ID => Tag\AmpMegaphoneDataPlaylist::ID,
        Tag\AmpNextPageScriptTypeApplicationJson::ID => Tag\AmpNextPageScriptTypeApplicationJson::ID,
        Tag\AmpNextPageFooter::ID => Tag\AmpNextPageFooter::ID,
        Tag\AmpNextPageRecommendationBox::ID => Tag\AmpNextPageRecommendationBox::ID,
        Tag\AmpNextPageSeparator::ID => Tag\AmpNextPageSeparator::ID,
        Tag\AmpNextPageWithInlineConfig::ID => Tag\AmpNextPageWithInlineConfig::ID,
        Tag\AmpNextPageWithSrcAttribute::ID => Tag\AmpNextPageWithSrcAttribute::ID,
        Tag\AmpNextPageTypeAdsense::ID => Tag\AmpNextPageTypeAdsense::ID,
        Tag\AmpScriptExtensionLocalScript::ID => Tag\AmpScriptExtensionLocalScript::ID,
        Tag\AmpSelectorChild::ID => Tag\AmpSelectorChild::ID,
        Tag\AmpSelectorOption::ID => Tag\AmpSelectorOption::ID,
        Tag\AmpSidebar::ID => Tag\AmpSidebar::ID,
        Tag\AmpSidebarAmp4email::ID => Tag\AmpSidebarAmp4email::ID,
        Tag\AmpSidebarNav::ID => Tag\AmpSidebarNav::ID,
        Tag\AmpState::ID => Tag\AmpState::ID,
        Tag\AmpStateAmp4email::ID => Tag\AmpStateAmp4email::ID,
        Tag\AmpStoryAnimationJsonScript::ID => Tag\AmpStoryAnimationJsonScript::ID,
        Tag\AmpStoryAutoAdsTemplate::ID => Tag\AmpStoryAutoAdsTemplate::ID,
        Tag\AmpStoryAutoAdsConfigScript::ID => Tag\AmpStoryAutoAdsConfigScript::ID,
        Tag\AmpStoryBookendExtensionJsonScript::ID => Tag\AmpStoryBookendExtensionJsonScript::ID,
        Tag\AmpStoryConsentExtensionJsonScript::ID => Tag\AmpStoryConsentExtensionJsonScript::ID,
        Tag\AmpStoryCtaLayerAnimateIn::ID => Tag\AmpStoryCtaLayerAnimateIn::ID,
        Tag\AmpStoryGridLayerAnimateIn::ID => Tag\AmpStoryGridLayerAnimateIn::ID,
        Tag\AmpStoryGridLayerDefault::ID => Tag\AmpStoryGridLayerDefault::ID,
        Tag\AmpStoryPageAttachment::ID => Tag\AmpStoryPageAttachment::ID,
        Tag\AmpStoryPageAttachmentHref::ID => Tag\AmpStoryPageAttachmentHref::ID,
        Tag\AmpStoryPageOutlink::ID => Tag\AmpStoryPageOutlink::ID,
        Tag\AmpStoryPlayerImg::ID => Tag\AmpStoryPlayerImg::ID,
        Tag\AmpStorySocialShareExtensionJsonScript::ID => Tag\AmpStorySocialShareExtensionJsonScript::ID,
        Tag\AmpStoryAmpAudio::ID => Tag\AmpStoryAmpAudio::ID,
        Tag\AmpStoryAmpSidebar::ID => Tag\AmpStoryAmpSidebar::ID,
        Tag\AmpStoryAmpStoryPageAttachmentAmpVideo::ID => Tag\AmpStoryAmpStoryPageAttachmentAmpVideo::ID,
        Tag\AmpStoryAmpVideo::ID => Tag\AmpStoryAmpVideo::ID,
        Tag\AmpSubscriptionsExtensionJsonScript::ID => Tag\AmpSubscriptionsExtensionJsonScript::ID,
        Tag\AmpVideoIframeTransformed::ID => Tag\AmpVideoIframeTransformed::ID,
        Tag\AmpVideoSource::ID => Tag\AmpVideoSource::ID,
        Tag\AmpVideoTrack::ID => Tag\AmpVideoTrack::ID,
        Tag\AmpVideoTrackKindSubtitles::ID => Tag\AmpVideoTrackKindSubtitles::ID,
        Tag\Amp4adsEngineScript::ID => Tag\Amp4adsEngineScript::ID,
        Tag\AmphtmlEngineScript::ID => Tag\AmphtmlEngineScript::ID,
        Tag\AmphtmlEngineScriptLts::ID => Tag\AmphtmlEngineScriptLts::ID,
        Tag\AmphtmlEngineScriptAmp4email::ID => Tag\AmphtmlEngineScriptAmp4email::ID,
        Tag\AmphtmlModuleEngineScript::ID => Tag\AmphtmlModuleEngineScript::ID,
        Tag\AmphtmlModuleLtsEngineScript::ID => Tag\AmphtmlModuleLtsEngineScript::ID,
        Tag\AmphtmlNomoduleEngineScript::ID => Tag\AmphtmlNomoduleEngineScript::ID,
        Tag\AmphtmlNomoduleLtsEngineScript::ID => Tag\AmphtmlNomoduleLtsEngineScript::ID,
        Tag\AudioSource::ID => Tag\AudioSource::ID,
        Tag\AudioTrack::ID => Tag\AudioTrack::ID,
        Tag\AudioTrackKindSubtitles::ID => Tag\AudioTrackKindSubtitles::ID,
        Tag\ButtonAmpNestedMenu::ID => Tag\ButtonAmpNestedMenu::ID,
        Tag\CryptokeysJsonScript::ID => Tag\CryptokeysJsonScript::ID,
        Tag\DivAmpNestedMenu::ID => Tag\DivAmpNestedMenu::ID,
        Tag\FormDivSubmitError::ID => Tag\FormDivSubmitError::ID,
        Tag\FormDivSubmitErrorTemplate::ID => Tag\FormDivSubmitErrorTemplate::ID,
        Tag\FormDivSubmitSuccess::ID => Tag\FormDivSubmitSuccess::ID,
        Tag\FormDivSubmitSuccessTemplate::ID => Tag\FormDivSubmitSuccessTemplate::ID,
        Tag\FormDivSubmitting::ID => Tag\FormDivSubmitting::ID,
        Tag\FormDivSubmittingTemplate::ID => Tag\FormDivSubmittingTemplate::ID,
        Tag\FormDivVerifyError::ID => Tag\FormDivVerifyError::ID,
        Tag\FormDivVerifyErrorTemplate::ID => Tag\FormDivVerifyErrorTemplate::ID,
        Tag\FormMethodGet::ID => Tag\FormMethodGet::ID,
        Tag\FormMethodGetAmp4email::ID => Tag\FormMethodGetAmp4email::ID,
        Tag\FormMethodPost::ID => Tag\FormMethodPost::ID,
        Tag\FormMethodPostAmp4email::ID => Tag\FormMethodPostAmp4email::ID,
        Tag\H2AmpNestedMenu::ID => Tag\H2AmpNestedMenu::ID,
        Tag\H3AmpNestedMenu::ID => Tag\H3AmpNestedMenu::ID,
        Tag\H4AmpNestedMenu::ID => Tag\H4AmpNestedMenu::ID,
        Tag\H5AmpNestedMenu::ID => Tag\H5AmpNestedMenu::ID,
        Tag\H6AmpNestedMenu::ID => Tag\H6AmpNestedMenu::ID,
        Tag\HeadStyleAmpBoilerplate::ID => Tag\HeadStyleAmpBoilerplate::ID,
        Tag\HeadStyleAmpBoilerplateTransformed::ID => Tag\HeadStyleAmpBoilerplateTransformed::ID,
        Tag\HeadStyleAmp4adsBoilerplate::ID => Tag\HeadStyleAmp4adsBoilerplate::ID,
        Tag\HeadStyleAmp4emailBoilerplate::ID => Tag\HeadStyleAmp4emailBoilerplate::ID,
        Tag\HtmlTransformed::ID => Tag\HtmlTransformed::ID,
        Tag\HtmlDoctype::ID => Tag\HtmlDoctype::ID,
        Tag\HtmlDoctypeAmp4ads::ID => Tag\HtmlDoctypeAmp4ads::ID,
        Tag\IAmphtmlSizerIntrinsic::ID => Tag\IAmphtmlSizerIntrinsic::ID,
        Tag\IAmphtmlSizerResponsive::ID => Tag\IAmphtmlSizerResponsive::ID,
        Tag\ImgIAmphtmlIntrinsicSizer::ID => Tag\ImgIAmphtmlIntrinsicSizer::ID,
        Tag\ImgIAmphtmlIntrinsicSizerAmpStoryPlayer::ID => Tag\ImgIAmphtmlIntrinsicSizerAmpStoryPlayer::ID,
        Tag\InputMaskDateDdMmYyyy::ID => Tag\InputMaskDateDdMmYyyy::ID,
        Tag\InputMaskDateMmDdYyyy::ID => Tag\InputMaskDateMmDdYyyy::ID,
        Tag\InputMaskDateMmYy::ID => Tag\InputMaskDateMmYy::ID,
        Tag\InputMaskDateYyyyMmDd::ID => Tag\InputMaskDateYyyyMmDd::ID,
        Tag\InputMaskPaymentCard::ID => Tag\InputMaskPaymentCard::ID,
        Tag\InputMaskCustomMask::ID => Tag\InputMaskCustomMask::ID,
        Tag\InputTypeFile::ID => Tag\InputTypeFile::ID,
        Tag\InputTypePassword::ID => Tag\InputTypePassword::ID,
        Tag\LineargradientStop::ID => Tag\LineargradientStop::ID,
        Tag\LinkItemprop::ID => Tag\LinkItemprop::ID,
        Tag\LinkItempropSameas::ID => Tag\LinkItempropSameas::ID,
        Tag\LinkProperty::ID => Tag\LinkProperty::ID,
        Tag\LinkRel::ID => Tag\LinkRel::ID,
        Tag\LinkRelCanonical::ID => Tag\LinkRelCanonical::ID,
        Tag\LinkRelManifest::ID => Tag\LinkRelManifest::ID,
        Tag\LinkRelModulepreload::ID => Tag\LinkRelModulepreload::ID,
        Tag\LinkRelPreload::ID => Tag\LinkRelPreload::ID,
        Tag\LinkRelStylesheetForFonts::ID => Tag\LinkRelStylesheetForFonts::ID,
        Tag\MetaCharsetUtf8::ID => Tag\MetaCharsetUtf8::ID,
        Tag\MetaHttpEquivContentLanguage::ID => Tag\MetaHttpEquivContentLanguage::ID,
        Tag\MetaHttpEquivContentScriptType::ID => Tag\MetaHttpEquivContentScriptType::ID,
        Tag\MetaHttpEquivContentStyleType::ID => Tag\MetaHttpEquivContentStyleType::ID,
        Tag\MetaHttpEquivContentType::ID => Tag\MetaHttpEquivContentType::ID,
        Tag\MetaHttpEquivImagetoolbar::ID => Tag\MetaHttpEquivImagetoolbar::ID,
        Tag\MetaHttpEquivOriginTrial::ID => Tag\MetaHttpEquivOriginTrial::ID,
        Tag\MetaHttpEquivPicsLabel::ID => Tag\MetaHttpEquivPicsLabel::ID,
        Tag\MetaHttpEquivResourceType::ID => Tag\MetaHttpEquivResourceType::ID,
        Tag\MetaHttpEquivXDnsPrefetchControl::ID => Tag\MetaHttpEquivXDnsPrefetchControl::ID,
        Tag\MetaHttpEquivXUaCompatible::ID => Tag\MetaHttpEquivXUaCompatible::ID,
        Tag\MetaNameAmp3pIframeSrc::ID => Tag\MetaNameAmp3pIframeSrc::ID,
        Tag\MetaNameAmpAdDoubleclickSra::ID => Tag\MetaNameAmpAdDoubleclickSra::ID,
        Tag\MetaNameAmpAdEnableRefresh::ID => Tag\MetaNameAmpAdEnableRefresh::ID,
        Tag\MetaNameAmpConsentBlocking::ID => Tag\MetaNameAmpConsentBlocking::ID,
        Tag\MetaNameAmpCtaLandingPageType::ID => Tag\MetaNameAmpCtaLandingPageType::ID,
        Tag\MetaNameAmpCtaType::ID => Tag\MetaNameAmpCtaType::ID,
        Tag\MetaNameAmpCtaUrl::ID => Tag\MetaNameAmpCtaUrl::ID,
        Tag\MetaNameAmpExperimentToken::ID => Tag\MetaNameAmpExperimentToken::ID,
        Tag\MetaNameAmpExperimentsOptIn::ID => Tag\MetaNameAmpExperimentsOptIn::ID,
        Tag\MetaNameAmpGoogleClientidIdApi::ID => Tag\MetaNameAmpGoogleClientidIdApi::ID,
        Tag\MetaNameAmpLinkVariableAllowedOrigin::ID => Tag\MetaNameAmpLinkVariableAllowedOrigin::ID,
        Tag\MetaNameAmpListLoadMore::ID => Tag\MetaNameAmpListLoadMore::ID,
        Tag\MetaNameAmpRecaptchaInput::ID => Tag\MetaNameAmpRecaptchaInput::ID,
        Tag\MetaNameAmpScriptSrc::ID => Tag\MetaNameAmpScriptSrc::ID,
        Tag\MetaNameAmpStoryGeneratorName::ID => Tag\MetaNameAmpStoryGeneratorName::ID,
        Tag\MetaNameAmpStoryGeneratorVersion::ID => Tag\MetaNameAmpStoryGeneratorVersion::ID,
        Tag\MetaNameAmpToAmpNavigation::ID => Tag\MetaNameAmpToAmpNavigation::ID,
        Tag\MetaNameAmp4adsId::ID => Tag\MetaNameAmp4adsId::ID,
        Tag\MetaNameAmp4adsVars::ID => Tag\MetaNameAmp4adsVars::ID,
        Tag\MetaNameAndContent::ID => Tag\MetaNameAndContent::ID,
        Tag\MetaNameAppleItunesApp::ID => Tag\MetaNameAppleItunesApp::ID,
        Tag\MetaNameViewport::ID => Tag\MetaNameViewport::ID,
        Tag\NoscriptImg::ID => Tag\NoscriptImg::ID,
        Tag\NoscriptStyleAmpBoilerplate::ID => Tag\NoscriptStyleAmpBoilerplate::ID,
        Tag\NoscriptStyleAmpBoilerplateTransformed::ID => Tag\NoscriptStyleAmpBoilerplateTransformed::ID,
        Tag\NoscriptEnclosureForBoilerplate::ID => Tag\NoscriptEnclosureForBoilerplate::ID,
        Tag\NoscriptEnclosureForBoilerplateTransformed::ID => Tag\NoscriptEnclosureForBoilerplateTransformed::ID,
        Tag\PictureSource::ID => Tag\PictureSource::ID,
        Tag\RadialgradientStop::ID => Tag\RadialgradientStop::ID,
        Tag\ScriptAmpOnerrorV0Js::ID => Tag\ScriptAmpOnerrorV0Js::ID,
        Tag\ScriptAmpOnerrorV0JsOrV0Mjs::ID => Tag\ScriptAmpOnerrorV0JsOrV0Mjs::ID,
        Tag\ScriptIdAmpRtc::ID => Tag\ScriptIdAmpRtc::ID,
        Tag\ScriptTypeApplicationLdJson::ID => Tag\ScriptTypeApplicationLdJson::ID,
        Tag\ScriptTypeTextPlain::ID => Tag\ScriptTypeTextPlain::ID,
        Tag\ScriptTypeTextPlainAmp4email::ID => Tag\ScriptTypeTextPlainAmp4email::ID,
        Tag\ScriptCustomElementAmpAccordionAmp4email::ID => Tag\ScriptCustomElementAmpAccordionAmp4email::ID,
        Tag\ScriptCustomElementAmpAutocompleteAmp4email::ID => Tag\ScriptCustomElementAmpAutocompleteAmp4email::ID,
        Tag\ScriptCustomElementAmpBindAmp4email::ID => Tag\ScriptCustomElementAmpBindAmp4email::ID,
        Tag\ScriptCustomElementAmpCarouselAmp4email::ID => Tag\ScriptCustomElementAmpCarouselAmp4email::ID,
        Tag\ScriptCustomElementAmpFitTextAmp4email::ID => Tag\ScriptCustomElementAmpFitTextAmp4email::ID,
        Tag\ScriptCustomElementAmpFormAmp4email::ID => Tag\ScriptCustomElementAmpFormAmp4email::ID,
        Tag\ScriptCustomElementAmpImageLightboxAmp4email::ID => Tag\ScriptCustomElementAmpImageLightboxAmp4email::ID,
        Tag\ScriptCustomElementAmpLightboxAmp4ads::ID => Tag\ScriptCustomElementAmpLightboxAmp4ads::ID,
        Tag\ScriptCustomElementAmpLightboxAmp4email::ID => Tag\ScriptCustomElementAmpLightboxAmp4email::ID,
        Tag\ScriptCustomElementAmpListAmp4email::ID => Tag\ScriptCustomElementAmpListAmp4email::ID,
        Tag\ScriptCustomElementAmpSelectorAmp4email::ID => Tag\ScriptCustomElementAmpSelectorAmp4email::ID,
        Tag\ScriptCustomElementAmpSidebarAmp4email::ID => Tag\ScriptCustomElementAmpSidebarAmp4email::ID,
        Tag\ScriptCustomElementAmpTimeagoAmp4email::ID => Tag\ScriptCustomElementAmpTimeagoAmp4email::ID,
        Tag\ScriptCustomTemplateAmpMustacheAmp4ads::ID => Tag\ScriptCustomTemplateAmpMustacheAmp4ads::ID,
        Tag\ScriptCustomTemplateAmpMustacheAmp4email::ID => Tag\ScriptCustomTemplateAmpMustacheAmp4email::ID,
        Tag\SectionAmp4email::ID => Tag\SectionAmp4email::ID,
        Tag\SpanAmpNestedMenu::ID => Tag\SpanAmpNestedMenu::ID,
        Tag\SpanSwgAmpCacheNonce::ID => Tag\SpanSwgAmpCacheNonce::ID,
        Tag\StyleAmpCustom::ID => Tag\StyleAmpCustom::ID,
        Tag\StyleAmpCustomAmp4ads::ID => Tag\StyleAmpCustomAmp4ads::ID,
        Tag\StyleAmpCustomAmp4email::ID => Tag\StyleAmpCustomAmp4email::ID,
        Tag\StyleAmpCustomCssStrict::ID => Tag\StyleAmpCustomCssStrict::ID,
        Tag\StyleAmpCustomLengthCheck::ID => Tag\StyleAmpCustomLengthCheck::ID,
        Tag\StyleAmpKeyframes::ID => Tag\StyleAmpKeyframes::ID,
        Tag\StyleAmpRuntimeTransformed::ID => Tag\StyleAmpRuntimeTransformed::ID,
        Tag\SubscriptionsSectionContentSwgAmpCacheNonce::ID => Tag\SubscriptionsSectionContentSwgAmpCacheNonce::ID,
        Tag\SubscriptionsScriptCiphertext::ID => Tag\SubscriptionsScriptCiphertext::ID,
        Tag\SvgTitle::ID => Tag\SvgTitle::ID,
        Tag\TemplateAmp4email::ID => Tag\TemplateAmp4email::ID,
        Tag\Title::ID => Tag\Title::ID,
        Tag\TitleAmp4email::ID => Tag\TitleAmp4email::ID,
        Tag\VideoSource::ID => Tag\VideoSource::ID,
        Tag\VideoTrack::ID => Tag\VideoTrack::ID,
        Tag\VideoTrackKindSubtitles::ID => Tag\VideoTrackKindSubtitles::ID,
    ];

    /**
     * Mapping of AMP format to array of tag IDs.
     *
     * This is used to optimize querying by AMP format.
     *
     * @var array<array<string>>
     */
    const BY_FORMAT = [
        Format::AMP => [
            Tag\A::ID,
            Tag\Abbr::ID,
            Tag\Acronym::ID,
            Tag\Address::ID,
            Tag\Amp3dGltf::ID,
            Tag\Amp3qPlayer::ID,
            Tag\AmpAccessExtensionJsonScript::ID,
            Tag\AmpAccordion::ID,
            Tag\AmpAccordionSection::ID,
            Tag\AmpActionMacro::ID,
            Tag\AmpAd::ID,
            Tag\AmpAdCustom::ID,
            Tag\AmpAddthis::ID,
            Tag\AmpAdExtensionScript::ID,
            Tag\AmpAdWithDataEnableRefreshAttribute::ID,
            Tag\AmpAdWithDataMultiSizeAttribute::ID,
            Tag\AmpAdWithTypeCustom::ID,
            Tag\AmpAnalytics::ID,
            Tag\AmpAnalyticsExtensionJsonScript::ID,
            Tag\AmpAnim::ID,
            Tag\AmpAnimation::ID,
            Tag\AmpAnimationExtensionJsonScript::ID,
            Tag\AmpApesterMedia::ID,
            Tag\AmpAppBanner::ID,
            Tag\AmpAppBannerButtonOpenButton::ID,
            Tag\AmpAudio::ID,
            Tag\AmpAudioSource::ID,
            Tag\AmpAudioTrack::ID,
            Tag\AmpAudioTrackKindSubtitles::ID,
            Tag\AmpAutoAds::ID,
            Tag\AmpAutocomplete::ID,
            Tag\AmpAutocompleteInput::ID,
            Tag\AmpAutocompleteJson::ID,
            Tag\AmpBaseCarousel::ID,
            Tag\AmpBaseCarouselLightboxChild::ID,
            Tag\AmpBaseCarouselLightboxLightboxExclude::ID,
            Tag\AmpBaseCarouselLightbox::ID,
            Tag\AmpBeopinion::ID,
            Tag\AmpBindMacro::ID,
            Tag\AmpBindExtensionJsonScript::ID,
            Tag\AmpBodymovinAnimation::ID,
            Tag\AmpBridPlayer::ID,
            Tag\AmpBrightcove::ID,
            Tag\AmpBysideContent::ID,
            Tag\AmpCallTracking::ID,
            Tag\AmpCarousel::ID,
            Tag\AmpCarouselLightbox::ID,
            Tag\AmpCarouselLightboxChild::ID,
            Tag\AmpCarouselLightboxLightboxExclude::ID,
            Tag\AmpConnatixPlayer::ID,
            Tag\AmpConsent::ID,
            Tag\AmpConsentExtensionJsonScript::ID,
            Tag\AmpConsentType::ID,
            Tag\AmpDailymotion::ID,
            Tag\AmpDateCountdown::ID,
            Tag\AmpDateDisplay::ID,
            Tag\AmpDatePickerTemplateDateTemplate::ID,
            Tag\AmpDatePickerTemplateInfoTemplate::ID,
            Tag\AmpDatePickerTypeRangeModeOverlay::ID,
            Tag\AmpDatePickerTypeRangeModeStatic::ID,
            Tag\AmpDatePickerTypeSingleModeOverlay::ID,
            Tag\AmpDatePickerTypeSingleModeStatic::ID,
            Tag\AmpDelightPlayer::ID,
            Tag\AmpEmbed::ID,
            Tag\AmpEmbedlyCard::ID,
            Tag\AmpEmbedlyKey::ID,
            Tag\AmpEmbedWithDataMultiSizeAttribute::ID,
            Tag\AmpExperiment::ID,
            Tag\AmpExperimentExtensionJsonScript::ID,
            Tag\AmpExperimentStoryExtensionJsonScript::ID,
            Tag\AmpFacebook::ID,
            Tag\AmpFacebookComments::ID,
            Tag\AmpFacebookLike::ID,
            Tag\AmpFacebookPage::ID,
            Tag\AmpFitText::ID,
            Tag\AmpFont::ID,
            Tag\AmpFxFlyingCarpet::ID,
            Tag\AmpGeo::ID,
            Tag\AmpGeoExtensionJsonScript::ID,
            Tag\AmpGfycat::ID,
            Tag\AmpGist::ID,
            Tag\AmpGoogleAssistantAssistjsConfig::ID,
            Tag\AmpGoogleAssistantInlineSuggestionBar::ID,
            Tag\AmpGoogleAssistantVoiceBar::ID,
            Tag\AmpGoogleAssistantVoiceButton::ID,
            Tag\AmpGoogleDocumentEmbed::ID,
            Tag\AmpHulu::ID,
            Tag\AmpIframe::ID,
            Tag\AmpIframely::ID,
            Tag\AmpImaVideo::ID,
            Tag\AmpImaVideoScriptTypeApplicationJson::ID,
            Tag\AmpImaVideoSource::ID,
            Tag\AmpImaVideoTrack::ID,
            Tag\AmpImaVideoTrackKindSubtitles::ID,
            Tag\AmpImageLightbox::ID,
            Tag\AmpImageSlider::ID,
            Tag\AmpImageSliderTransformed::ID,
            Tag\AmpImageSliderDivFirst::ID,
            Tag\AmpImageSliderDivSecond::ID,
            Tag\AmpImg::ID,
            Tag\AmpImgTransformed::ID,
            Tag\AmpImgImgTransformed::ID,
            Tag\AmpImgImgPlaceholderTransformed::ID,
            Tag\AmpImgur::ID,
            Tag\AmpInlineGallery::ID,
            Tag\AmpInlineGalleryPagination::ID,
            Tag\AmpInlineGalleryPaginationInset::ID,
            Tag\AmpInlineGalleryThumbnails::ID,
            Tag\AmpInstagram::ID,
            Tag\AmpInstallServiceworker::ID,
            Tag\AmpIzlesene::ID,
            Tag\AmpJwplayer::ID,
            Tag\AmpKalturaPlayer::ID,
            Tag\AmpLayout::ID,
            Tag\AmpLightbox::ID,
            Tag\AmpLinkRewriter::ID,
            Tag\AmpLinkRewriterExtensionJsonScript::ID,
            Tag\AmpList::ID,
            Tag\AmpListLoadMore::ID,
            Tag\AmpListLoadMoreButtonLoadMoreClickable::ID,
            Tag\AmpListDivFetchError::ID,
            Tag\AmpLiveList::ID,
            Tag\AmpLiveListItems::ID,
            Tag\AmpLiveListItemsItem::ID,
            Tag\AmpLiveListPagination::ID,
            Tag\AmpLiveListUpdate::ID,
            Tag\AmpMathml::ID,
            Tag\AmpMegaMenu::ID,
            Tag\AmpMegaMenuAmpList::ID,
            Tag\AmpMegaMenuAmpListTemplate::ID,
            Tag\AmpMegaMenuNav::ID,
            Tag\AmpMegaMenuItemContent::ID,
            Tag\AmpMegaMenuItemHeading::ID,
            Tag\AmpMegaMenuNavUlOl::ID,
            Tag\AmpMegaMenuNavUlOlLi::ID,
            Tag\AmpMegaphoneDataEpisode::ID,
            Tag\AmpMegaphoneDataPlaylist::ID,
            Tag\AmpMinuteMediaPlayer::ID,
            Tag\AmpMowplayer::ID,
            Tag\AmpNestedMenu::ID,
            Tag\AmpNextPageScriptTypeApplicationJson::ID,
            Tag\AmpNextPageFooter::ID,
            Tag\AmpNextPageRecommendationBox::ID,
            Tag\AmpNextPageSeparator::ID,
            Tag\AmpNextPageWithInlineConfig::ID,
            Tag\AmpNextPageWithSrcAttribute::ID,
            Tag\AmpNextPageTypeAdsense::ID,
            Tag\AmpNexxtvPlayer::ID,
            Tag\AmpO2Player::ID,
            Tag\AmpOnetapGoogle::ID,
            Tag\AmpOoyalaPlayer::ID,
            Tag\AmpOrientationObserver::ID,
            Tag\AmpPanZoom::ID,
            Tag\AmpPinterest::ID,
            Tag\AmpPixel::ID,
            Tag\AmpPlaybuzz::ID,
            Tag\AmpPositionObserver::ID,
            Tag\AmpPowrPlayer::ID,
            Tag\AmpReachPlayer::ID,
            Tag\AmpRecaptchaInput::ID,
            Tag\AmpRedbullPlayer::ID,
            Tag\AmpReddit::ID,
            Tag\AmpRender::ID,
            Tag\AmpRiddleQuiz::ID,
            Tag\AmpScript::ID,
            Tag\AmpScriptExtensionLocalScript::ID,
            Tag\AmpSelector::ID,
            Tag\AmpSelectorChild::ID,
            Tag\AmpSelectorOption::ID,
            Tag\AmpSidebar::ID,
            Tag\AmpSidebarNav::ID,
            Tag\AmpSkimlinks::ID,
            Tag\AmpSmartlinks::ID,
            Tag\AmpSocialShare::ID,
            Tag\AmpSoundcloud::ID,
            Tag\AmpSpringboardPlayer::ID,
            Tag\AmpState::ID,
            Tag\AmpStickyAd::ID,
            Tag\AmpStory::ID,
            Tag\AmpStory360::ID,
            Tag\AmpStoryAnimation::ID,
            Tag\AmpStoryAnimationJsonScript::ID,
            Tag\AmpStoryAutoAds::ID,
            Tag\AmpStoryAutoAdsTemplate::ID,
            Tag\AmpStoryAutoAdsConfigScript::ID,
            Tag\AmpStoryAutoAnalytics::ID,
            Tag\AmpStoryBookend::ID,
            Tag\AmpStoryBookendExtensionJsonScript::ID,
            Tag\AmpStoryConsent::ID,
            Tag\AmpStoryConsentExtensionJsonScript::ID,
            Tag\AmpStoryCtaLayer::ID,
            Tag\AmpStoryCtaLayerAnimateIn::ID,
            Tag\AmpStoryGridLayer::ID,
            Tag\AmpStoryGridLayerAnimateIn::ID,
            Tag\AmpStoryGridLayerDefault::ID,
            Tag\AmpStoryInteractiveBinaryPoll::ID,
            Tag\AmpStoryInteractivePoll::ID,
            Tag\AmpStoryInteractiveQuiz::ID,
            Tag\AmpStoryInteractiveResults::ID,
            Tag\AmpStoryPage::ID,
            Tag\AmpStoryPageAttachment::ID,
            Tag\AmpStoryPageAttachmentHref::ID,
            Tag\AmpStoryPageOutlink::ID,
            Tag\AmpStoryPanningMedia::ID,
            Tag\AmpStoryPlayer::ID,
            Tag\AmpStoryPlayerImg::ID,
            Tag\AmpStorySocialShare::ID,
            Tag\AmpStorySocialShareExtensionJsonScript::ID,
            Tag\AmpStoryAmpAudio::ID,
            Tag\AmpStoryAmpSidebar::ID,
            Tag\AmpStoryAmpStoryPageAttachmentAmpVideo::ID,
            Tag\AmpStoryAmpVideo::ID,
            Tag\AmpStreamGallery::ID,
            Tag\AmpSubscriptionsExtensionJsonScript::ID,
            Tag\AmpTimeago::ID,
            Tag\AmpTruncateText::ID,
            Tag\AmpTwitter::ID,
            Tag\AmpUserNotification::ID,
            Tag\AmpVideo::ID,
            Tag\AmpVideoIframe::ID,
            Tag\AmpVideoIframeTransformed::ID,
            Tag\AmpVideoSource::ID,
            Tag\AmpVideoTrack::ID,
            Tag\AmpVideoTrackKindSubtitles::ID,
            Tag\AmpVimeo::ID,
            Tag\AmpVine::ID,
            Tag\AmpViqeoPlayer::ID,
            Tag\AmpVk::ID,
            Tag\AmpWebPush::ID,
            Tag\AmpWebPushWidget::ID,
            Tag\AmpWistiaPlayer::ID,
            Tag\AmpYotpo::ID,
            Tag\AmpYoutube::ID,
            Tag\AmphtmlEngineScript::ID,
            Tag\AmphtmlEngineScriptLts::ID,
            Tag\AmphtmlModuleEngineScript::ID,
            Tag\AmphtmlModuleLtsEngineScript::ID,
            Tag\AmphtmlNomoduleEngineScript::ID,
            Tag\AmphtmlNomoduleLtsEngineScript::ID,
            Tag\Article::ID,
            Tag\Aside::ID,
            Tag\Audio::ID,
            Tag\AudioSource::ID,
            Tag\AudioTrack::ID,
            Tag\AudioTrackKindSubtitles::ID,
            Tag\B::ID,
            Tag\Base::ID,
            Tag\Bdi::ID,
            Tag\Bdo::ID,
            Tag\Big::ID,
            Tag\Blockquote::ID,
            Tag\Body::ID,
            Tag\Br::ID,
            Tag\Button::ID,
            Tag\ButtonAmpNestedMenu::ID,
            Tag\Canvas::ID,
            Tag\Caption::ID,
            Tag\Center::ID,
            Tag\Circle::ID,
            Tag\Cite::ID,
            Tag\Clippath::ID,
            Tag\Code::ID,
            Tag\Col::ID,
            Tag\Colgroup::ID,
            Tag\CryptokeysJsonScript::ID,
            Tag\Data::ID,
            Tag\Datalist::ID,
            Tag\Dd::ID,
            Tag\Defs::ID,
            Tag\Del::ID,
            Tag\Desc::ID,
            Tag\Details::ID,
            Tag\Dfn::ID,
            Tag\Dir::ID,
            Tag\Div::ID,
            Tag\DivAmpNestedMenu::ID,
            Tag\Dl::ID,
            Tag\Dt::ID,
            Tag\Ellipse::ID,
            Tag\Em::ID,
            Tag\Feblend::ID,
            Tag\Fecolormatrix::ID,
            Tag\Fecomponenttransfer::ID,
            Tag\Fecomposite::ID,
            Tag\Feconvolvematrix::ID,
            Tag\Fediffuselighting::ID,
            Tag\Fedisplacementmap::ID,
            Tag\Fedistantlight::ID,
            Tag\Fedropshadow::ID,
            Tag\Feflood::ID,
            Tag\Fefunca::ID,
            Tag\Fefuncb::ID,
            Tag\Fefuncg::ID,
            Tag\Fefuncr::ID,
            Tag\Fegaussianblur::ID,
            Tag\Femerge::ID,
            Tag\Femergenode::ID,
            Tag\Femorphology::ID,
            Tag\Feoffset::ID,
            Tag\Fepointlight::ID,
            Tag\Fespecularlighting::ID,
            Tag\Fespotlight::ID,
            Tag\Fetile::ID,
            Tag\Feturbulence::ID,
            Tag\Fieldset::ID,
            Tag\Figcaption::ID,
            Tag\Figure::ID,
            Tag\Filter::ID,
            Tag\Footer::ID,
            Tag\FormDivSubmitError::ID,
            Tag\FormDivSubmitErrorTemplate::ID,
            Tag\FormDivSubmitSuccess::ID,
            Tag\FormDivSubmitSuccessTemplate::ID,
            Tag\FormDivSubmitting::ID,
            Tag\FormDivSubmittingTemplate::ID,
            Tag\FormDivVerifyError::ID,
            Tag\FormDivVerifyErrorTemplate::ID,
            Tag\FormMethodGet::ID,
            Tag\FormMethodPost::ID,
            Tag\G::ID,
            Tag\Glyph::ID,
            Tag\Glyphref::ID,
            Tag\H1::ID,
            Tag\H2::ID,
            Tag\H2AmpNestedMenu::ID,
            Tag\H3::ID,
            Tag\H3AmpNestedMenu::ID,
            Tag\H4::ID,
            Tag\H4AmpNestedMenu::ID,
            Tag\H5::ID,
            Tag\H5AmpNestedMenu::ID,
            Tag\H6::ID,
            Tag\H6AmpNestedMenu::ID,
            Tag\Head::ID,
            Tag\HeadStyleAmpBoilerplate::ID,
            Tag\HeadStyleAmpBoilerplateTransformed::ID,
            Tag\Header::ID,
            Tag\Hgroup::ID,
            Tag\Hkern::ID,
            Tag\Hr::ID,
            Tag\Html::ID,
            Tag\HtmlTransformed::ID,
            Tag\HtmlDoctype::ID,
            Tag\I::ID,
            Tag\IAmphtmlSizerIntrinsic::ID,
            Tag\IAmphtmlSizerResponsive::ID,
            Tag\Iframe::ID,
            Tag\Image::ID,
            Tag\ImgIAmphtmlIntrinsicSizer::ID,
            Tag\ImgIAmphtmlIntrinsicSizerAmpStoryPlayer::ID,
            Tag\Input::ID,
            Tag\InputMaskDateDdMmYyyy::ID,
            Tag\InputMaskDateMmDdYyyy::ID,
            Tag\InputMaskDateMmYy::ID,
            Tag\InputMaskDateYyyyMmDd::ID,
            Tag\InputMaskPaymentCard::ID,
            Tag\InputMaskCustomMask::ID,
            Tag\InputTypeFile::ID,
            Tag\InputTypePassword::ID,
            Tag\Ins::ID,
            Tag\Kbd::ID,
            Tag\Label::ID,
            Tag\Legend::ID,
            Tag\Li::ID,
            Tag\Line::ID,
            Tag\Lineargradient::ID,
            Tag\LineargradientStop::ID,
            Tag\LinkItemprop::ID,
            Tag\LinkItempropSameas::ID,
            Tag\LinkProperty::ID,
            Tag\LinkRel::ID,
            Tag\LinkRelCanonical::ID,
            Tag\LinkRelManifest::ID,
            Tag\LinkRelModulepreload::ID,
            Tag\LinkRelPreload::ID,
            Tag\LinkRelStylesheetForFonts::ID,
            Tag\Listing::ID,
            Tag\Main::ID,
            Tag\Mark::ID,
            Tag\Marker::ID,
            Tag\Mask::ID,
            Tag\MetaCharsetUtf8::ID,
            Tag\Metadata::ID,
            Tag\MetaHttpEquivContentLanguage::ID,
            Tag\MetaHttpEquivContentScriptType::ID,
            Tag\MetaHttpEquivContentStyleType::ID,
            Tag\MetaHttpEquivContentType::ID,
            Tag\MetaHttpEquivImagetoolbar::ID,
            Tag\MetaHttpEquivOriginTrial::ID,
            Tag\MetaHttpEquivPicsLabel::ID,
            Tag\MetaHttpEquivResourceType::ID,
            Tag\MetaHttpEquivXDnsPrefetchControl::ID,
            Tag\MetaHttpEquivXUaCompatible::ID,
            Tag\MetaNameAmp3pIframeSrc::ID,
            Tag\MetaNameAmpAdDoubleclickSra::ID,
            Tag\MetaNameAmpAdEnableRefresh::ID,
            Tag\MetaNameAmpConsentBlocking::ID,
            Tag\MetaNameAmpExperimentToken::ID,
            Tag\MetaNameAmpExperimentsOptIn::ID,
            Tag\MetaNameAmpGoogleClientidIdApi::ID,
            Tag\MetaNameAmpLinkVariableAllowedOrigin::ID,
            Tag\MetaNameAmpListLoadMore::ID,
            Tag\MetaNameAmpRecaptchaInput::ID,
            Tag\MetaNameAmpScriptSrc::ID,
            Tag\MetaNameAmpStoryGeneratorName::ID,
            Tag\MetaNameAmpStoryGeneratorVersion::ID,
            Tag\MetaNameAmpToAmpNavigation::ID,
            Tag\MetaNameAndContent::ID,
            Tag\MetaNameAppleItunesApp::ID,
            Tag\MetaNameViewport::ID,
            Tag\Meter::ID,
            Tag\Multicol::ID,
            Tag\Nav::ID,
            Tag\Nextid::ID,
            Tag\Nobr::ID,
            Tag\Noscript::ID,
            Tag\NoscriptImg::ID,
            Tag\NoscriptStyleAmpBoilerplate::ID,
            Tag\NoscriptStyleAmpBoilerplateTransformed::ID,
            Tag\NoscriptEnclosureForBoilerplate::ID,
            Tag\NoscriptEnclosureForBoilerplateTransformed::ID,
            Tag\OP::ID,
            Tag\Ol::ID,
            Tag\Optgroup::ID,
            Tag\Option::ID,
            Tag\Output::ID,
            Tag\P::ID,
            Tag\Path::ID,
            Tag\Pattern::ID,
            Tag\Picture::ID,
            Tag\PictureSource::ID,
            Tag\Polygon::ID,
            Tag\Polyline::ID,
            Tag\Pre::ID,
            Tag\Progress::ID,
            Tag\Q::ID,
            Tag\Radialgradient::ID,
            Tag\RadialgradientStop::ID,
            Tag\Rb::ID,
            Tag\Rect::ID,
            Tag\Rp::ID,
            Tag\Rt::ID,
            Tag\Rtc::ID,
            Tag\Ruby::ID,
            Tag\S::ID,
            Tag\Samp::ID,
            Tag\ScriptAmpOnerrorV0Js::ID,
            Tag\ScriptAmpOnerrorV0JsOrV0Mjs::ID,
            Tag\ScriptIdAmpRtc::ID,
            Tag\ScriptTypeApplicationLdJson::ID,
            Tag\ScriptTypeTextPlain::ID,
            Tag\ScriptAmp3dGltf::ID,
            Tag\ScriptAmp3qPlayer::ID,
            Tag\ScriptAmpAccessLaterpay::ID,
            Tag\ScriptAmpAccessPoool::ID,
            Tag\ScriptAmpAccessScroll::ID,
            Tag\ScriptAmpAccess::ID,
            Tag\ScriptAmpAccordion::ID,
            Tag\ScriptAmpAccordion2::ID,
            Tag\ScriptAmpActionMacro::ID,
            Tag\ScriptAmpAdCustom::ID,
            Tag\ScriptAmpAddthis::ID,
            Tag\ScriptAmpAnalytics::ID,
            Tag\ScriptAmpAnimation::ID,
            Tag\ScriptAmpAnim::ID,
            Tag\ScriptAmpApesterMedia::ID,
            Tag\ScriptAmpAppBanner::ID,
            Tag\ScriptAmpAudio::ID,
            Tag\ScriptAmpAutoAds::ID,
            Tag\ScriptAmpAutocomplete::ID,
            Tag\ScriptAmpBaseCarousel::ID,
            Tag\ScriptAmpBeopinion::ID,
            Tag\ScriptAmpBind::ID,
            Tag\ScriptAmpBodymovinAnimation::ID,
            Tag\ScriptAmpBridPlayer::ID,
            Tag\ScriptAmpBrightcove::ID,
            Tag\ScriptAmpBysideContent::ID,
            Tag\ScriptAmpCacheUrl::ID,
            Tag\ScriptAmpCallTracking::ID,
            Tag\ScriptAmpCarousel::ID,
            Tag\ScriptAmpConnatixPlayer::ID,
            Tag\ScriptAmpConsent::ID,
            Tag\ScriptAmpDailymotion::ID,
            Tag\ScriptAmpDateCountdown::ID,
            Tag\ScriptAmpDateDisplay::ID,
            Tag\ScriptAmpDatePicker::ID,
            Tag\ScriptAmpDelightPlayer::ID,
            Tag\ScriptAmpDynamicCssClasses::ID,
            Tag\ScriptAmpEmbedlyCard::ID,
            Tag\ScriptAmpExperiment::ID,
            Tag\ScriptAmpFacebookComments::ID,
            Tag\ScriptAmpFacebookLike::ID,
            Tag\ScriptAmpFacebookPage::ID,
            Tag\ScriptAmpFacebook::ID,
            Tag\ScriptAmpFitText::ID,
            Tag\ScriptAmpFitText2::ID,
            Tag\ScriptAmpFont::ID,
            Tag\ScriptAmpForm::ID,
            Tag\ScriptAmpFxCollection::ID,
            Tag\ScriptAmpFxFlyingCarpet::ID,
            Tag\ScriptAmpGeo::ID,
            Tag\ScriptAmpGfycat::ID,
            Tag\ScriptAmpGist::ID,
            Tag\ScriptAmpGoogleAssistantAssistjs::ID,
            Tag\ScriptAmpGoogleDocumentEmbed::ID,
            Tag\ScriptAmpHulu::ID,
            Tag\ScriptAmpIframely::ID,
            Tag\ScriptAmpIframe::ID,
            Tag\ScriptAmpImaVideo::ID,
            Tag\ScriptAmpImageLightbox::ID,
            Tag\ScriptAmpImageSlider::ID,
            Tag\ScriptAmpImgur::ID,
            Tag\ScriptAmpInlineGallery::ID,
            Tag\ScriptAmpInputmask::ID,
            Tag\ScriptAmpInstagram::ID,
            Tag\ScriptAmpInstagram2::ID,
            Tag\ScriptAmpInstallServiceworker::ID,
            Tag\ScriptAmpIzlesene::ID,
            Tag\ScriptAmpJwplayer::ID,
            Tag\ScriptAmpKalturaPlayer::ID,
            Tag\ScriptAmpLightboxGallery::ID,
            Tag\ScriptAmpLightbox::ID,
            Tag\ScriptAmpLightbox2::ID,
            Tag\ScriptAmpLinkRewriter::ID,
            Tag\ScriptAmpList::ID,
            Tag\ScriptAmpLiveList::ID,
            Tag\ScriptAmpMathml::ID,
            Tag\ScriptAmpMegaMenu::ID,
            Tag\ScriptAmpMegaphone::ID,
            Tag\ScriptAmpMinuteMediaPlayer::ID,
            Tag\ScriptAmpMowplayer::ID,
            Tag\ScriptAmpMustache::ID,
            Tag\ScriptAmpNestedMenu::ID,
            Tag\ScriptAmpNextPage::ID,
            Tag\ScriptAmpNexxtvPlayer::ID,
            Tag\ScriptAmpO2Player::ID,
            Tag\ScriptAmpOnetapGoogle::ID,
            Tag\ScriptAmpOoyalaPlayer::ID,
            Tag\ScriptAmpOrientationObserver::ID,
            Tag\ScriptAmpPanZoom::ID,
            Tag\ScriptAmpPinterest::ID,
            Tag\ScriptAmpPlaybuzz::ID,
            Tag\ScriptAmpPositionObserver::ID,
            Tag\ScriptAmpPowrPlayer::ID,
            Tag\ScriptAmpReachPlayer::ID,
            Tag\ScriptAmpRecaptchaInput::ID,
            Tag\ScriptAmpRedbullPlayer::ID,
            Tag\ScriptAmpReddit::ID,
            Tag\ScriptAmpRender::ID,
            Tag\ScriptAmpRiddleQuiz::ID,
            Tag\ScriptAmpScript::ID,
            Tag\ScriptAmpSelector::ID,
            Tag\ScriptAmpSelector2::ID,
            Tag\ScriptAmpSidebar::ID,
            Tag\ScriptAmpSkimlinks::ID,
            Tag\ScriptAmpSlides::ID,
            Tag\ScriptAmpSmartlinks::ID,
            Tag\ScriptAmpSocialShare::ID,
            Tag\ScriptAmpSocialShare2::ID,
            Tag\ScriptAmpSoundcloud::ID,
            Tag\ScriptAmpSpringboardPlayer::ID,
            Tag\ScriptAmpStickyAd::ID,
            Tag\ScriptAmpStory360::ID,
            Tag\ScriptAmpStoryAutoAds::ID,
            Tag\ScriptAmpStoryAutoAnalytics::ID,
            Tag\ScriptAmpStoryInteractive::ID,
            Tag\ScriptAmpStoryPanningMedia::ID,
            Tag\ScriptAmpStoryPlayer::ID,
            Tag\ScriptAmpStory::ID,
            Tag\ScriptAmpStreamGallery::ID,
            Tag\ScriptAmpSubscriptionsGoogle::ID,
            Tag\ScriptAmpSubscriptions::ID,
            Tag\ScriptAmpTimeago::ID,
            Tag\ScriptAmpTruncateText::ID,
            Tag\ScriptAmpTwitter::ID,
            Tag\ScriptAmpTwitter2::ID,
            Tag\ScriptAmpUserNotification::ID,
            Tag\ScriptAmpVideoDocking::ID,
            Tag\ScriptAmpVideoIframe::ID,
            Tag\ScriptAmpVideoIframe2::ID,
            Tag\ScriptAmpVideo::ID,
            Tag\ScriptAmpVideo2::ID,
            Tag\ScriptAmpVimeo::ID,
            Tag\ScriptAmpVimeo2::ID,
            Tag\ScriptAmpVine::ID,
            Tag\ScriptAmpViqeoPlayer::ID,
            Tag\ScriptAmpVk::ID,
            Tag\ScriptAmpWebPush::ID,
            Tag\ScriptAmpWistiaPlayer::ID,
            Tag\ScriptAmpYotpo::ID,
            Tag\ScriptAmpYoutube::ID,
            Tag\ScriptAmpYoutube2::ID,
            Tag\Section::ID,
            Tag\Select::ID,
            Tag\Slot::ID,
            Tag\Small::ID,
            Tag\Solidcolor::ID,
            Tag\Spacer::ID,
            Tag\Span::ID,
            Tag\SpanAmpNestedMenu::ID,
            Tag\SpanSwgAmpCacheNonce::ID,
            Tag\Strike::ID,
            Tag\Strong::ID,
            Tag\StyleAmpCustom::ID,
            Tag\StyleAmpCustomLengthCheck::ID,
            Tag\StyleAmpKeyframes::ID,
            Tag\StyleAmpRuntimeTransformed::ID,
            Tag\Sub::ID,
            Tag\SubscriptionsSectionContentSwgAmpCacheNonce::ID,
            Tag\SubscriptionsScriptCiphertext::ID,
            Tag\Summary::ID,
            Tag\Sup::ID,
            Tag\Svg::ID,
            Tag\SvgTitle::ID,
            Tag\Switch_::ID,
            Tag\Symbol::ID,
            Tag\Table::ID,
            Tag\Tbody::ID,
            Tag\Td::ID,
            Tag\Template::ID,
            Tag\Text::ID,
            Tag\Textarea::ID,
            Tag\Textpath::ID,
            Tag\Tfoot::ID,
            Tag\Th::ID,
            Tag\Thead::ID,
            Tag\Time::ID,
            Tag\Title::ID,
            Tag\Tr::ID,
            Tag\Tref::ID,
            Tag\Tspan::ID,
            Tag\Tt::ID,
            Tag\U::ID,
            Tag\Ul::ID,
            Tag\Use_::ID,
            Tag\Var_::ID,
            Tag\Video::ID,
            Tag\VideoSource::ID,
            Tag\VideoTrack::ID,
            Tag\VideoTrackKindSubtitles::ID,
            Tag\View::ID,
            Tag\Vkern::ID,
            Tag\Wbr::ID,
        ],
        Format::AMP4ADS => [
            Tag\A::ID,
            Tag\Abbr::ID,
            Tag\Address::ID,
            Tag\AmpAccordion::ID,
            Tag\AmpAccordionSection::ID,
            Tag\AmpAdExit::ID,
            Tag\AmpAdExitConfigurationJson::ID,
            Tag\AmpAnalytics::ID,
            Tag\AmpAnalyticsExtensionJsonScript::ID,
            Tag\AmpAnim::ID,
            Tag\AmpAnimation::ID,
            Tag\AmpAnimationExtensionJsonScript::ID,
            Tag\AmpAppBannerButtonOpenButton::ID,
            Tag\AmpAudioA4a::ID,
            Tag\AmpAudioSource::ID,
            Tag\AmpAudioTrack::ID,
            Tag\AmpAudioTrackKindSubtitles::ID,
            Tag\AmpBindExtensionJsonScript::ID,
            Tag\AmpCarousel::ID,
            Tag\AmpFitText::ID,
            Tag\AmpFont::ID,
            Tag\AmpGwdAnimation::ID,
            Tag\AmpImaVideoSource::ID,
            Tag\AmpImg::ID,
            Tag\AmpLayout::ID,
            Tag\AmpLightboxAmp4ads::ID,
            Tag\AmpListDivFetchError::ID,
            Tag\AmpPixel::ID,
            Tag\AmpPositionObserver::ID,
            Tag\AmpSelector::ID,
            Tag\AmpSelectorChild::ID,
            Tag\AmpSelectorOption::ID,
            Tag\AmpSocialShare::ID,
            Tag\AmpStateAmp4email::ID,
            Tag\AmpStoryAmpStoryPageAttachmentAmpVideo::ID,
            Tag\AmpStoryAmpVideo::ID,
            Tag\AmpVideo::ID,
            Tag\AmpVideoSource::ID,
            Tag\AmpVideoTrack::ID,
            Tag\AmpVideoTrackKindSubtitles::ID,
            Tag\Amp4adsEngineScript::ID,
            Tag\Article::ID,
            Tag\Aside::ID,
            Tag\AudioSource::ID,
            Tag\AudioTrack::ID,
            Tag\AudioTrackKindSubtitles::ID,
            Tag\B::ID,
            Tag\Base::ID,
            Tag\Bdi::ID,
            Tag\Bdo::ID,
            Tag\Blockquote::ID,
            Tag\Body::ID,
            Tag\Br::ID,
            Tag\Button::ID,
            Tag\Caption::ID,
            Tag\Circle::ID,
            Tag\Cite::ID,
            Tag\Clippath::ID,
            Tag\Code::ID,
            Tag\Col::ID,
            Tag\Colgroup::ID,
            Tag\Data::ID,
            Tag\Datalist::ID,
            Tag\Dd::ID,
            Tag\Defs::ID,
            Tag\Del::ID,
            Tag\Desc::ID,
            Tag\Details::ID,
            Tag\Dfn::ID,
            Tag\Div::ID,
            Tag\Dl::ID,
            Tag\Dt::ID,
            Tag\Ellipse::ID,
            Tag\Em::ID,
            Tag\Feblend::ID,
            Tag\Fecolormatrix::ID,
            Tag\Fecomponenttransfer::ID,
            Tag\Fecomposite::ID,
            Tag\Feconvolvematrix::ID,
            Tag\Fediffuselighting::ID,
            Tag\Fedisplacementmap::ID,
            Tag\Fedistantlight::ID,
            Tag\Fedropshadow::ID,
            Tag\Feflood::ID,
            Tag\Fefunca::ID,
            Tag\Fefuncb::ID,
            Tag\Fefuncg::ID,
            Tag\Fefuncr::ID,
            Tag\Fegaussianblur::ID,
            Tag\Femerge::ID,
            Tag\Femergenode::ID,
            Tag\Femorphology::ID,
            Tag\Feoffset::ID,
            Tag\Fepointlight::ID,
            Tag\Fespecularlighting::ID,
            Tag\Fespotlight::ID,
            Tag\Fetile::ID,
            Tag\Feturbulence::ID,
            Tag\Fieldset::ID,
            Tag\Figcaption::ID,
            Tag\Figure::ID,
            Tag\Filter::ID,
            Tag\Footer::ID,
            Tag\FormDivSubmitError::ID,
            Tag\FormDivSubmitErrorTemplate::ID,
            Tag\FormDivSubmitSuccess::ID,
            Tag\FormDivSubmitSuccessTemplate::ID,
            Tag\FormDivSubmitting::ID,
            Tag\FormDivSubmittingTemplate::ID,
            Tag\FormDivVerifyError::ID,
            Tag\FormDivVerifyErrorTemplate::ID,
            Tag\FormMethodGet::ID,
            Tag\FormMethodPost::ID,
            Tag\G::ID,
            Tag\Glyph::ID,
            Tag\Glyphref::ID,
            Tag\H1::ID,
            Tag\H2::ID,
            Tag\H3::ID,
            Tag\H4::ID,
            Tag\H5::ID,
            Tag\H6::ID,
            Tag\Head::ID,
            Tag\HeadStyleAmp4adsBoilerplate::ID,
            Tag\Header::ID,
            Tag\Hkern::ID,
            Tag\Hr::ID,
            Tag\Html::ID,
            Tag\HtmlDoctypeAmp4ads::ID,
            Tag\I::ID,
            Tag\Image::ID,
            Tag\Input::ID,
            Tag\Ins::ID,
            Tag\Kbd::ID,
            Tag\Label::ID,
            Tag\Legend::ID,
            Tag\Li::ID,
            Tag\Line::ID,
            Tag\Lineargradient::ID,
            Tag\LineargradientStop::ID,
            Tag\LinkItemprop::ID,
            Tag\LinkItempropSameas::ID,
            Tag\LinkProperty::ID,
            Tag\LinkRel::ID,
            Tag\LinkRelManifest::ID,
            Tag\LinkRelPreload::ID,
            Tag\LinkRelStylesheetForFonts::ID,
            Tag\Main::ID,
            Tag\Mark::ID,
            Tag\Marker::ID,
            Tag\Mask::ID,
            Tag\MetaCharsetUtf8::ID,
            Tag\Metadata::ID,
            Tag\MetaHttpEquivContentLanguage::ID,
            Tag\MetaHttpEquivContentScriptType::ID,
            Tag\MetaHttpEquivContentStyleType::ID,
            Tag\MetaHttpEquivContentType::ID,
            Tag\MetaHttpEquivImagetoolbar::ID,
            Tag\MetaHttpEquivOriginTrial::ID,
            Tag\MetaHttpEquivPicsLabel::ID,
            Tag\MetaHttpEquivResourceType::ID,
            Tag\MetaHttpEquivXUaCompatible::ID,
            Tag\MetaNameAmpAdEnableRefresh::ID,
            Tag\MetaNameAmpCtaLandingPageType::ID,
            Tag\MetaNameAmpCtaType::ID,
            Tag\MetaNameAmpCtaUrl::ID,
            Tag\MetaNameAmpExperimentsOptIn::ID,
            Tag\MetaNameAmp4adsId::ID,
            Tag\MetaNameAmp4adsVars::ID,
            Tag\MetaNameAndContent::ID,
            Tag\MetaNameAppleItunesApp::ID,
            Tag\MetaNameViewport::ID,
            Tag\Meter::ID,
            Tag\Nav::ID,
            Tag\Ol::ID,
            Tag\Optgroup::ID,
            Tag\Option::ID,
            Tag\Output::ID,
            Tag\P::ID,
            Tag\Path::ID,
            Tag\Pattern::ID,
            Tag\Polygon::ID,
            Tag\Polyline::ID,
            Tag\Pre::ID,
            Tag\Progress::ID,
            Tag\Q::ID,
            Tag\Radialgradient::ID,
            Tag\RadialgradientStop::ID,
            Tag\Rb::ID,
            Tag\Rect::ID,
            Tag\Rp::ID,
            Tag\Rt::ID,
            Tag\Rtc::ID,
            Tag\Ruby::ID,
            Tag\S::ID,
            Tag\Samp::ID,
            Tag\ScriptTypeApplicationLdJson::ID,
            Tag\ScriptTypeTextPlain::ID,
            Tag\ScriptAmpAccordion2::ID,
            Tag\ScriptAmpAdExit::ID,
            Tag\ScriptAmpAnalytics::ID,
            Tag\ScriptAmpAnimation::ID,
            Tag\ScriptAmpAnim::ID,
            Tag\ScriptAmpAudio::ID,
            Tag\ScriptAmpBind::ID,
            Tag\ScriptAmpCarousel::ID,
            Tag\ScriptAmpFitText2::ID,
            Tag\ScriptAmpFont::ID,
            Tag\ScriptAmpForm::ID,
            Tag\ScriptAmpGwdAnimation::ID,
            Tag\ScriptAmpMraid::ID,
            Tag\ScriptAmpPositionObserver::ID,
            Tag\ScriptAmpSelector2::ID,
            Tag\ScriptAmpSocialShare2::ID,
            Tag\ScriptAmpVideo2::ID,
            Tag\ScriptCustomElementAmpLightboxAmp4ads::ID,
            Tag\ScriptCustomTemplateAmpMustacheAmp4ads::ID,
            Tag\Section::ID,
            Tag\Select::ID,
            Tag\Small::ID,
            Tag\Solidcolor::ID,
            Tag\Span::ID,
            Tag\Strong::ID,
            Tag\StyleAmpCustomAmp4ads::ID,
            Tag\StyleAmpCustomLengthCheck::ID,
            Tag\StyleAmpKeyframes::ID,
            Tag\Sub::ID,
            Tag\Summary::ID,
            Tag\Sup::ID,
            Tag\Svg::ID,
            Tag\SvgTitle::ID,
            Tag\Switch_::ID,
            Tag\Symbol::ID,
            Tag\Table::ID,
            Tag\Tbody::ID,
            Tag\Td::ID,
            Tag\Template::ID,
            Tag\Text::ID,
            Tag\Textarea::ID,
            Tag\Textpath::ID,
            Tag\Tfoot::ID,
            Tag\Th::ID,
            Tag\Thead::ID,
            Tag\Time::ID,
            Tag\Title::ID,
            Tag\Tr::ID,
            Tag\Tref::ID,
            Tag\Tspan::ID,
            Tag\U::ID,
            Tag\Ul::ID,
            Tag\Use_::ID,
            Tag\Var_::ID,
            Tag\VideoSource::ID,
            Tag\VideoTrack::ID,
            Tag\VideoTrackKindSubtitles::ID,
            Tag\View::ID,
            Tag\Vkern::ID,
            Tag\Wbr::ID,
        ],
        Format::AMP4EMAIL => [
            Tag\AAmp4email::ID,
            Tag\Abbr::ID,
            Tag\Address::ID,
            Tag\AmpAccordion::ID,
            Tag\AmpAccordionSection::ID,
            Tag\AmpAnimAmp4email::ID,
            Tag\AmpAnimExtensionScriptAmp4email::ID,
            Tag\AmpAutocompleteAmp4email::ID,
            Tag\AmpBindMacro::ID,
            Tag\AmpBindExtensionJsonScript::ID,
            Tag\AmpCarousel::ID,
            Tag\AmpFitText::ID,
            Tag\AmpImageLightbox::ID,
            Tag\AmpImgAmp4email::ID,
            Tag\AmpLayout::ID,
            Tag\AmpLightbox::ID,
            Tag\AmpListAmp4email::ID,
            Tag\AmpListDivFetchError::ID,
            Tag\AmpSelector::ID,
            Tag\AmpSelectorChild::ID,
            Tag\AmpSelectorOption::ID,
            Tag\AmpSidebarAmp4email::ID,
            Tag\AmpSidebarNav::ID,
            Tag\AmpStateAmp4email::ID,
            Tag\AmpTimeago::ID,
            Tag\AmphtmlEngineScriptAmp4email::ID,
            Tag\Article::ID,
            Tag\Aside::ID,
            Tag\B::ID,
            Tag\Bdo::ID,
            Tag\Blockquote::ID,
            Tag\Body::ID,
            Tag\Br::ID,
            Tag\Button::ID,
            Tag\Caption::ID,
            Tag\Cite::ID,
            Tag\Code::ID,
            Tag\Col::ID,
            Tag\Colgroup::ID,
            Tag\Data::ID,
            Tag\Datalist::ID,
            Tag\Dd::ID,
            Tag\Del::ID,
            Tag\Details::ID,
            Tag\Dfn::ID,
            Tag\Div::ID,
            Tag\Dl::ID,
            Tag\Dt::ID,
            Tag\Em::ID,
            Tag\Fieldset::ID,
            Tag\Figcaption::ID,
            Tag\Figure::ID,
            Tag\Footer::ID,
            Tag\FormDivSubmitError::ID,
            Tag\FormDivSubmitErrorTemplate::ID,
            Tag\FormDivSubmitSuccess::ID,
            Tag\FormDivSubmitSuccessTemplate::ID,
            Tag\FormDivSubmitting::ID,
            Tag\FormMethodGetAmp4email::ID,
            Tag\FormMethodPostAmp4email::ID,
            Tag\H1::ID,
            Tag\H2::ID,
            Tag\H3::ID,
            Tag\H4::ID,
            Tag\H5::ID,
            Tag\H6::ID,
            Tag\Head::ID,
            Tag\HeadStyleAmp4emailBoilerplate::ID,
            Tag\Header::ID,
            Tag\Hr::ID,
            Tag\Html::ID,
            Tag\HtmlDoctype::ID,
            Tag\I::ID,
            Tag\Input::ID,
            Tag\Ins::ID,
            Tag\Kbd::ID,
            Tag\Label::ID,
            Tag\Legend::ID,
            Tag\Li::ID,
            Tag\Main::ID,
            Tag\Mark::ID,
            Tag\MetaCharsetUtf8::ID,
            Tag\MetaNameAndContent::ID,
            Tag\Meter::ID,
            Tag\Nav::ID,
            Tag\Ol::ID,
            Tag\Optgroup::ID,
            Tag\Option::ID,
            Tag\Output::ID,
            Tag\P::ID,
            Tag\Pre::ID,
            Tag\Progress::ID,
            Tag\Q::ID,
            Tag\Rb::ID,
            Tag\Rp::ID,
            Tag\Rt::ID,
            Tag\Ruby::ID,
            Tag\S::ID,
            Tag\Samp::ID,
            Tag\ScriptTypeApplicationLdJson::ID,
            Tag\ScriptTypeTextPlainAmp4email::ID,
            Tag\ScriptCustomElementAmpAccordionAmp4email::ID,
            Tag\ScriptCustomElementAmpAutocompleteAmp4email::ID,
            Tag\ScriptCustomElementAmpBindAmp4email::ID,
            Tag\ScriptCustomElementAmpCarouselAmp4email::ID,
            Tag\ScriptCustomElementAmpFitTextAmp4email::ID,
            Tag\ScriptCustomElementAmpFormAmp4email::ID,
            Tag\ScriptCustomElementAmpImageLightboxAmp4email::ID,
            Tag\ScriptCustomElementAmpLightboxAmp4email::ID,
            Tag\ScriptCustomElementAmpListAmp4email::ID,
            Tag\ScriptCustomElementAmpSelectorAmp4email::ID,
            Tag\ScriptCustomElementAmpSidebarAmp4email::ID,
            Tag\ScriptCustomElementAmpTimeagoAmp4email::ID,
            Tag\ScriptCustomTemplateAmpMustacheAmp4email::ID,
            Tag\SectionAmp4email::ID,
            Tag\Select::ID,
            Tag\Small::ID,
            Tag\Span::ID,
            Tag\Strong::ID,
            Tag\StyleAmpCustomAmp4email::ID,
            Tag\StyleAmpCustomCssStrict::ID,
            Tag\StyleAmpCustomLengthCheck::ID,
            Tag\Sub::ID,
            Tag\Summary::ID,
            Tag\Sup::ID,
            Tag\Table::ID,
            Tag\Tbody::ID,
            Tag\Td::ID,
            Tag\TemplateAmp4email::ID,
            Tag\Textarea::ID,
            Tag\Tfoot::ID,
            Tag\Th::ID,
            Tag\Thead::ID,
            Tag\Time::ID,
            Tag\TitleAmp4email::ID,
            Tag\Tr::ID,
            Tag\U::ID,
            Tag\Ul::ID,
            Tag\Var_::ID,
            Tag\Wbr::ID,
        ],
    ];

    /**
     * Mapping of extension name to tag ID.
     *
     * This is used to optimize querying by extension spec.
     *
     * @var array<string>
     */
    const BY_EXTENSION_SPEC = [
        Extension::AD => Tag\AmpAdExtensionScript::ID,
        Extension::ANIM => Tag\ScriptAmpAnim::ID,
        Extension::_3D_GLTF => Tag\ScriptAmp3dGltf::ID,
        Extension::_3Q_PLAYER => Tag\ScriptAmp3qPlayer::ID,
        Extension::ACCESS_LATERPAY => Tag\ScriptAmpAccessLaterpay::ID,
        Extension::ACCESS_POOOL => Tag\ScriptAmpAccessPoool::ID,
        Extension::ACCESS_SCROLL => Tag\ScriptAmpAccessScroll::ID,
        Extension::ACCESS => Tag\ScriptAmpAccess::ID,
        Extension::ACCORDION => Tag\ScriptCustomElementAmpAccordionAmp4email::ID,
        Extension::ACTION_MACRO => Tag\ScriptAmpActionMacro::ID,
        Extension::AD_CUSTOM => Tag\ScriptAmpAdCustom::ID,
        Extension::AD_EXIT => Tag\ScriptAmpAdExit::ID,
        Extension::ADDTHIS => Tag\ScriptAmpAddthis::ID,
        Extension::ANALYTICS => Tag\ScriptAmpAnalytics::ID,
        Extension::ANIMATION => Tag\ScriptAmpAnimation::ID,
        Extension::APESTER_MEDIA => Tag\ScriptAmpApesterMedia::ID,
        Extension::APP_BANNER => Tag\ScriptAmpAppBanner::ID,
        Extension::AUDIO => Tag\ScriptAmpAudio::ID,
        Extension::AUTO_ADS => Tag\ScriptAmpAutoAds::ID,
        Extension::AUTOCOMPLETE => Tag\ScriptCustomElementAmpAutocompleteAmp4email::ID,
        Extension::BASE_CAROUSEL => Tag\ScriptAmpBaseCarousel::ID,
        Extension::BEOPINION => Tag\ScriptAmpBeopinion::ID,
        Extension::BIND => Tag\ScriptCustomElementAmpBindAmp4email::ID,
        Extension::BODYMOVIN_ANIMATION => Tag\ScriptAmpBodymovinAnimation::ID,
        Extension::BRID_PLAYER => Tag\ScriptAmpBridPlayer::ID,
        Extension::BRIGHTCOVE => Tag\ScriptAmpBrightcove::ID,
        Extension::BYSIDE_CONTENT => Tag\ScriptAmpBysideContent::ID,
        Extension::CACHE_URL => Tag\ScriptAmpCacheUrl::ID,
        Extension::CALL_TRACKING => Tag\ScriptAmpCallTracking::ID,
        Extension::CAROUSEL => Tag\ScriptCustomElementAmpCarouselAmp4email::ID,
        Extension::CONNATIX_PLAYER => Tag\ScriptAmpConnatixPlayer::ID,
        Extension::CONSENT => Tag\ScriptAmpConsent::ID,
        Extension::DAILYMOTION => Tag\ScriptAmpDailymotion::ID,
        Extension::DATE_COUNTDOWN => Tag\ScriptAmpDateCountdown::ID,
        Extension::DATE_DISPLAY => Tag\ScriptAmpDateDisplay::ID,
        Extension::DATE_PICKER => Tag\ScriptAmpDatePicker::ID,
        Extension::DELIGHT_PLAYER => Tag\ScriptAmpDelightPlayer::ID,
        Extension::DYNAMIC_CSS_CLASSES => Tag\ScriptAmpDynamicCssClasses::ID,
        Extension::EMBEDLY_CARD => Tag\ScriptAmpEmbedlyCard::ID,
        Extension::EXPERIMENT => Tag\ScriptAmpExperiment::ID,
        Extension::FACEBOOK_COMMENTS => Tag\ScriptAmpFacebookComments::ID,
        Extension::FACEBOOK_LIKE => Tag\ScriptAmpFacebookLike::ID,
        Extension::FACEBOOK_PAGE => Tag\ScriptAmpFacebookPage::ID,
        Extension::FACEBOOK => Tag\ScriptAmpFacebook::ID,
        Extension::FIT_TEXT => Tag\ScriptCustomElementAmpFitTextAmp4email::ID,
        Extension::FONT => Tag\ScriptAmpFont::ID,
        Extension::FORM => Tag\ScriptCustomElementAmpFormAmp4email::ID,
        Extension::FX_COLLECTION => Tag\ScriptAmpFxCollection::ID,
        Extension::FX_FLYING_CARPET => Tag\ScriptAmpFxFlyingCarpet::ID,
        Extension::GEO => Tag\ScriptAmpGeo::ID,
        Extension::GFYCAT => Tag\ScriptAmpGfycat::ID,
        Extension::GIST => Tag\ScriptAmpGist::ID,
        Extension::GOOGLE_ASSISTANT_ASSISTJS => Tag\ScriptAmpGoogleAssistantAssistjs::ID,
        Extension::GOOGLE_DOCUMENT_EMBED => Tag\ScriptAmpGoogleDocumentEmbed::ID,
        Extension::GWD_ANIMATION => Tag\ScriptAmpGwdAnimation::ID,
        Extension::HULU => Tag\ScriptAmpHulu::ID,
        Extension::IFRAMELY => Tag\ScriptAmpIframely::ID,
        Extension::IFRAME => Tag\ScriptAmpIframe::ID,
        Extension::IMA_VIDEO => Tag\ScriptAmpImaVideo::ID,
        Extension::IMAGE_LIGHTBOX => Tag\ScriptCustomElementAmpImageLightboxAmp4email::ID,
        Extension::IMAGE_SLIDER => Tag\ScriptAmpImageSlider::ID,
        Extension::IMGUR => Tag\ScriptAmpImgur::ID,
        Extension::INLINE_GALLERY => Tag\ScriptAmpInlineGallery::ID,
        Extension::INPUTMASK => Tag\ScriptAmpInputmask::ID,
        Extension::INSTAGRAM => Tag\ScriptAmpInstagram2::ID,
        Extension::INSTALL_SERVICEWORKER => Tag\ScriptAmpInstallServiceworker::ID,
        Extension::IZLESENE => Tag\ScriptAmpIzlesene::ID,
        Extension::JWPLAYER => Tag\ScriptAmpJwplayer::ID,
        Extension::KALTURA_PLAYER => Tag\ScriptAmpKalturaPlayer::ID,
        Extension::LIGHTBOX_GALLERY => Tag\ScriptAmpLightboxGallery::ID,
        Extension::LIGHTBOX => Tag\ScriptCustomElementAmpLightboxAmp4email::ID,
        Extension::LINK_REWRITER => Tag\ScriptAmpLinkRewriter::ID,
        Extension::LIST_ => Tag\ScriptCustomElementAmpListAmp4email::ID,
        Extension::LIVE_LIST => Tag\ScriptAmpLiveList::ID,
        Extension::MATHML => Tag\ScriptAmpMathml::ID,
        Extension::MEGA_MENU => Tag\ScriptAmpMegaMenu::ID,
        Extension::MEGAPHONE => Tag\ScriptAmpMegaphone::ID,
        Extension::MINUTE_MEDIA_PLAYER => Tag\ScriptAmpMinuteMediaPlayer::ID,
        Extension::MOWPLAYER => Tag\ScriptAmpMowplayer::ID,
        Extension::MRAID => Tag\ScriptAmpMraid::ID,
        Extension::MUSTACHE => Tag\ScriptCustomTemplateAmpMustacheAmp4email::ID,
        Extension::NESTED_MENU => Tag\ScriptAmpNestedMenu::ID,
        Extension::NEXT_PAGE => Tag\ScriptAmpNextPage::ID,
        Extension::NEXXTV_PLAYER => Tag\ScriptAmpNexxtvPlayer::ID,
        Extension::O2_PLAYER => Tag\ScriptAmpO2Player::ID,
        Extension::ONETAP_GOOGLE => Tag\ScriptAmpOnetapGoogle::ID,
        Extension::OOYALA_PLAYER => Tag\ScriptAmpOoyalaPlayer::ID,
        Extension::ORIENTATION_OBSERVER => Tag\ScriptAmpOrientationObserver::ID,
        Extension::PAN_ZOOM => Tag\ScriptAmpPanZoom::ID,
        Extension::PINTEREST => Tag\ScriptAmpPinterest::ID,
        Extension::PLAYBUZZ => Tag\ScriptAmpPlaybuzz::ID,
        Extension::POSITION_OBSERVER => Tag\ScriptAmpPositionObserver::ID,
        Extension::POWR_PLAYER => Tag\ScriptAmpPowrPlayer::ID,
        Extension::REACH_PLAYER => Tag\ScriptAmpReachPlayer::ID,
        Extension::RECAPTCHA_INPUT => Tag\ScriptAmpRecaptchaInput::ID,
        Extension::REDBULL_PLAYER => Tag\ScriptAmpRedbullPlayer::ID,
        Extension::REDDIT => Tag\ScriptAmpReddit::ID,
        Extension::RENDER => Tag\ScriptAmpRender::ID,
        Extension::RIDDLE_QUIZ => Tag\ScriptAmpRiddleQuiz::ID,
        Extension::SCRIPT => Tag\ScriptAmpScript::ID,
        Extension::SELECTOR => Tag\ScriptCustomElementAmpSelectorAmp4email::ID,
        Extension::SIDEBAR => Tag\ScriptCustomElementAmpSidebarAmp4email::ID,
        Extension::SKIMLINKS => Tag\ScriptAmpSkimlinks::ID,
        Extension::SLIDES => Tag\ScriptAmpSlides::ID,
        Extension::SMARTLINKS => Tag\ScriptAmpSmartlinks::ID,
        Extension::SOCIAL_SHARE => Tag\ScriptAmpSocialShare2::ID,
        Extension::SOUNDCLOUD => Tag\ScriptAmpSoundcloud::ID,
        Extension::SPRINGBOARD_PLAYER => Tag\ScriptAmpSpringboardPlayer::ID,
        Extension::STICKY_AD => Tag\ScriptAmpStickyAd::ID,
        Extension::STORY_360 => Tag\ScriptAmpStory360::ID,
        Extension::STORY_AUTO_ADS => Tag\ScriptAmpStoryAutoAds::ID,
        Extension::STORY_AUTO_ANALYTICS => Tag\ScriptAmpStoryAutoAnalytics::ID,
        Extension::STORY_INTERACTIVE => Tag\ScriptAmpStoryInteractive::ID,
        Extension::STORY_PANNING_MEDIA => Tag\ScriptAmpStoryPanningMedia::ID,
        Extension::STORY_PLAYER => Tag\ScriptAmpStoryPlayer::ID,
        Extension::STORY => Tag\ScriptAmpStory::ID,
        Extension::STREAM_GALLERY => Tag\ScriptAmpStreamGallery::ID,
        Extension::SUBSCRIPTIONS_GOOGLE => Tag\ScriptAmpSubscriptionsGoogle::ID,
        Extension::SUBSCRIPTIONS => Tag\ScriptAmpSubscriptions::ID,
        Extension::TIMEAGO => Tag\ScriptCustomElementAmpTimeagoAmp4email::ID,
        Extension::TRUNCATE_TEXT => Tag\ScriptAmpTruncateText::ID,
        Extension::TWITTER => Tag\ScriptAmpTwitter2::ID,
        Extension::USER_NOTIFICATION => Tag\ScriptAmpUserNotification::ID,
        Extension::VIDEO_DOCKING => Tag\ScriptAmpVideoDocking::ID,
        Extension::VIDEO_IFRAME => Tag\ScriptAmpVideoIframe2::ID,
        Extension::VIDEO => Tag\ScriptAmpVideo2::ID,
        Extension::VIMEO => Tag\ScriptAmpVimeo2::ID,
        Extension::VINE => Tag\ScriptAmpVine::ID,
        Extension::VIQEO_PLAYER => Tag\ScriptAmpViqeoPlayer::ID,
        Extension::VK => Tag\ScriptAmpVk::ID,
        Extension::WEB_PUSH => Tag\ScriptAmpWebPush::ID,
        Extension::WISTIA_PLAYER => Tag\ScriptAmpWistiaPlayer::ID,
        Extension::YOTPO => Tag\ScriptAmpYotpo::ID,
        Extension::YOUTUBE => Tag\ScriptAmpYoutube2::ID,
    ];

    /**
     * Cache of instantiated Tag objects.
     *
     * @var array<Tag>
     */
    private $tagsCache = [];

    /**
     * Array used for storing the iteration index in.
     *
     * @var array<string>|null
     */
    private $iterationArray;

    /**
     * Get a collection of tags by tag name.
     *
     * @param string $tagName Tag name to get the collection of tags for.
     * @return array<Tag> Array of tags. Empty array if tag name not found.
     */
    public function byTagName($tagName)
    {
        $tagName = strtolower($tagName);

        if (!array_key_exists($tagName, self::BY_TAG_NAME)) {
            return [];
        }

        $tagIds = self::BY_TAG_NAME[$tagName];
        if (!is_array($tagIds)) {
            $tagIds = [$tagIds];
        }

        $tags = [];
        foreach ($tagIds as $tagId) {
            $tags[] = $this->byTagId($tagId);
        }

        return $tags;
    }

    /**
     * Get the tag for a given spec name.
     *
     * @param string $specName Spec name to get the tag for.
     * @return Tag Tag with the given spec name.
     * @throws InvalidSpecName If an invalid spec name is requested.
     */
    public function bySpecName($specName)
    {
        if (!array_key_exists($specName, self::BY_SPEC_NAME)) {
            throw InvalidSpecName::forSpecName($specName);
        }

        return $this->byTagId(self::BY_SPEC_NAME[$specName]);
    }

    /**
     * Get a collection of tags for a given AMP HTML format name.
     *
     * @param string $format AMP HTML format to get the tags for.
     * @return array<Tag> Array of tags matching the requested AMP HTML format.
     * @throws InvalidFormat If an invalid AMP HTML format is requested.
     */
    public function byFormat($format)
    {
        if (!array_key_exists($format, self::BY_FORMAT)) {
            throw InvalidFormat::forFormat($format);
        }

        $tagIds = self::BY_FORMAT[$format];
        if (!is_array($tagIds)) {
            $tagIds = [$tagIds];
        }

        $tags = [];
        foreach ($tagIds as $tagId) {
            $tags[] = $this->byTagId($tagId);
        }

        return $tags;
    }

    /**
     * Get the tag for a given extension spec name.
     *
     * @param string $extension Extension name to get the extension spec for.
     * @return TagWithExtensionSpec Tag with the given extension spec name.
     * @throws InvalidExtension If an invalid extension name is requested.
     * @throws LogicException If tag is not an instance of TagWithExtensionSpec.
     */
    public function byExtensionSpec($extension)
    {
        if (!array_key_exists($extension, self::BY_EXTENSION_SPEC)) {
            throw InvalidExtension::forExtension($extension);
        }

        $tag = $this->byTagId(self::BY_EXTENSION_SPEC[$extension]);

        if (!$tag instanceof TagWithExtensionSpec) {
            throw new LogicException('Tags::byExtensionSpec returned tag without extension spec');
        }

        return $tag;
    }

    /**
     * Get a tag by its tag ID.
     *
     * @param string $tagId Tag ID for which to get the tag.
     * @return Tag Tag object.
     */
    public function byTagId($tagId)
    {
        if (array_key_exists($tagId, $this->tagsCache)) {
            return $this->tagsCache[$tagId];
        }

        if (!array_key_exists($tagId, self::TAGS)) {
            throw InvalidTagId::forTagId($tagId);
        }

        $tagClassName = self::TAGS[$tagId];
        $tag          = new $tagClassName();

        $this->tagsCache[$tagId] = $tag;

        return $tag;
    }

    /**
     * Get the list of available keys.
     *
     * @return array<string> Array of available keys.
     */
    public function getAvailableKeys()
    {
        return array_keys(self::TAGS);
    }

    /**
     * Find the instantiated object for the current key.
     *
     * This should use its own caching mechanism as needed.
     *
     * Ideally, current() should be overridden as well to provide the correct object type-hint.
     *
     * @param string $key Key to retrieve the instantiated object for.
     * @return object Instantiated object for the current key.
     */
    public function findByKey($key)
    {
        return $this->byTagId($key);
    }

    /**
     * Return the current iterable object.
     *
     * @return Tag Tag object.
     */
    public function current()
    {
        return $this->parentCurrent();
    }
}
